/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.user;

import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public final class UsersRemovedEvent {
    private final Set<RemovedUser> removedUsers;

    public UsersRemovedEvent(RemovedUser removedUser) {
        this(Collections.singleton(removedUser));
    }

    public UsersRemovedEvent(Set<RemovedUser> removedUsers) {
        this.removedUsers = Collections.unmodifiableSet(removedUsers);
    }

    public Set<RemovedUser> getRemovedUsers() {
        return this.removedUsers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsersRemovedEvent that = (UsersRemovedEvent)o;
        return Objects.equals(this.removedUsers, that.removedUsers);
    }

    public int hashCode() {
        return Objects.hash(this.removedUsers);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("removedUsers", this.removedUsers).toString();
    }

    public record RemovedUser(String userKey, String username) {
        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("userKey", (Object)this.userKey).add("username", (Object)this.username).toString();
        }
    }
}

