/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.user;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.bc.security.login.LoginInfo;
import com.atlassian.jira.bc.security.login.LoginReason;
import com.atlassian.jira.event.user.UserEvent;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@Internal
public class LoginFailedEvent
extends UserEvent {
    private final LoginInfo loginInfo;
    private final LoginReason loginReason;
    private final String accessUrl;

    public LoginFailedEvent(ApplicationUser user, LoginInfo loginInfo, LoginReason loginReason) {
        this(user, loginInfo, loginReason, null);
    }

    public LoginFailedEvent(ApplicationUser user, LoginInfo loginInfo, LoginReason loginReason, @Nullable String accessUrl) {
        super(user, 7);
        this.loginInfo = loginInfo;
        this.loginReason = loginReason;
        this.accessUrl = accessUrl;
    }

    public LoginInfo getLoginInfo() {
        return this.loginInfo;
    }

    public LoginReason getLoginReason() {
        return this.loginReason;
    }

    public Optional<String> getUrl() {
        return Optional.ofNullable(this.accessUrl);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LoginFailedEvent that = (LoginFailedEvent)o;
        return Objects.equals(this.loginInfo, that.loginInfo) && this.loginReason == that.loginReason && Objects.equals(this.accessUrl, that.accessUrl);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.loginInfo, this.loginReason, this.accessUrl});
    }
}

