/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.project;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.jira.event.AbstractEvent;
import com.atlassian.jira.imports.project.core.ProjectImportResults;

@ExperimentalApi
@EventName(value="jira.project.imported")
public final class ProjectImportedEvent
extends AbstractEvent {
    private final int issuesCreatedCount;
    private final int attachmentsCreatedCount;
    private final int usersCreatedCount;
    private final long importDurationMillis;
    private final ProjectImportResults projectImportResults;

    public ProjectImportedEvent(ProjectImportResults projectImportResults) {
        this.issuesCreatedCount = projectImportResults.getIssuesCreatedCount();
        this.attachmentsCreatedCount = projectImportResults.getAttachmentsCreatedCount();
        this.usersCreatedCount = projectImportResults.getUsersCreatedCount();
        this.importDurationMillis = projectImportResults.getImportDuration();
        this.projectImportResults = projectImportResults;
    }

    public int getIssuesCreatedCount() {
        return this.issuesCreatedCount;
    }

    public int getAttachmentsCreatedCount() {
        return this.attachmentsCreatedCount;
    }

    public int getUsersCreatedCount() {
        return this.usersCreatedCount;
    }

    public long getImportDurationMillis() {
        return this.importDurationMillis;
    }

    public ProjectImportResults getProjectImportResults() {
        return this.projectImportResults;
    }
}

