/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.TaskContextAware;
import java.util.Objects;
import javax.annotation.Nonnull;

public class OwnershipTransferParameter
implements TaskContextAware {
    private final String currentUserKey;
    private final String transferToUserKey;
    private final Context context;

    public OwnershipTransferParameter(@Nonnull String currentUserKey, @Nonnull String transferToUserKey, @Nonnull Context context) {
        this.currentUserKey = Objects.requireNonNull(currentUserKey);
        this.transferToUserKey = Objects.requireNonNull(transferToUserKey);
        this.context = Objects.requireNonNull(context);
    }

    @Nonnull
    public String getCurrentUserKey() {
        return this.currentUserKey;
    }

    @Nonnull
    public String getTransferToUserKey() {
        return this.transferToUserKey;
    }

    @Override
    @Nonnull
    public Context getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OwnershipTransferParameter that = (OwnershipTransferParameter)o;
        return Objects.equals(this.currentUserKey, that.currentUserKey) && Objects.equals(this.transferToUserKey, that.transferToUserKey);
    }

    public int hashCode() {
        return Objects.hash(this.currentUserKey, this.transferToUserKey);
    }

    public String toString() {
        return "OwnershipTransferParameter{currentUserKey='" + this.currentUserKey + "', transferToUserKey='" + this.transferToUserKey + "'}";
    }
}

