/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.request;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.QuerySort;
import com.atlassian.jira.search.field.NestedField;
import com.atlassian.jira.search.request.AbstractSearchRequestBuilder;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

@Internal
public class SearchRequest {
    private final Collection<Field> fields;
    private final Map<NestedField, Collection<Field>> nestedFields;
    private final Query query;
    private final QuerySort sort;

    private SearchRequest(Builder builder) {
        this.fields = builder.fields.build();
        this.query = builder.query;
        this.sort = builder.sort;
        ImmutableMap.Builder nestedBuilder = ImmutableMap.builder();
        builder.nestedFields.forEach((key, value) -> nestedBuilder.put(key, (Object)value.build()));
        this.nestedFields = nestedBuilder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(Query query) {
        return new Builder(query);
    }

    public Collection<Field> getFields() {
        return this.fields;
    }

    public Map<NestedField, Collection<Field>> getNestedFields() {
        return this.nestedFields;
    }

    public Query getQuery() {
        return this.query;
    }

    public Optional<QuerySort> getSort() {
        return Optional.ofNullable(this.sort);
    }

    public static class Builder
    extends AbstractSearchRequestBuilder<Builder> {
        private Query query;
        private QuerySort sort;

        public Builder() {
        }

        public Builder(Query query) {
            this();
            this.query = Objects.requireNonNull(query, "query");
        }

        public SearchRequest build() {
            Objects.requireNonNull(this.query, "Query is required");
            return new SearchRequest(this);
        }

        public Builder query(Query value) {
            this.query = Objects.requireNonNull(value, "query");
            return this.self();
        }

        public Builder sort(@Nullable QuerySort value) {
            this.sort = value;
            return this.self();
        }

        @Override
        protected Builder self() {
            return this;
        }
    }
}

