/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.index;

import com.atlassian.jira.search.Document;
import com.atlassian.jira.search.index.IndexRequest;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public final class UpdateBulkRequest {
    private final Set<IndexRequest> updateRequests;

    private UpdateBulkRequest(Builder builder) {
        this.updateRequests = builder.bulkBuilder.build();
    }

    public Set<IndexRequest> getRequests() {
        return this.updateRequests;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableSet.Builder<IndexRequest> bulkBuilder = ImmutableSet.builder();

        public Builder put(String documentId, Document document) {
            this.bulkBuilder.add((Object)IndexRequest.builder(documentId, document).build());
            return this;
        }

        public Builder put(String documentId, long version, Document document) {
            this.bulkBuilder.add((Object)IndexRequest.builder(documentId, version, document).build());
            return this;
        }

        public UpdateBulkRequest build() {
            return new UpdateBulkRequest(this);
        }

        public Builder putAll(Set<IndexRequest> indexRequests) {
            this.bulkBuilder.addAll(indexRequests);
            return this;
        }
    }
}

