/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.renderer.IssueRenderContext;
import com.atlassian.jira.issue.fields.rest.json.CommentBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.dbc.Assertions;

public class DefaultCommentBeanFactory
implements CommentBeanFactory {
    private final ProjectRoleManager projectRoleManager;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;
    private final RendererManager rendererManager;
    private final JiraBaseUrls jiraBaseUrls;
    private final FieldLayoutManager fieldLayoutManager;

    public DefaultCommentBeanFactory(ProjectRoleManager projectRoleManager, DateTimeFormatterFactory dateTimeFormatterFactory, RendererManager rendererManager, JiraBaseUrls jiraBaseUrls, FieldLayoutManager fieldLayoutManager) {
        this.projectRoleManager = projectRoleManager;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
        this.rendererManager = rendererManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.fieldLayoutManager = fieldLayoutManager;
    }

    @Override
    @Deprecated
    public CommentJsonBean createBean(Comment comment) {
        return this.createBean(comment, ComponentAccessor.getComponent(JiraAuthenticationContext.class).getUser(), ComponentAccessor.getComponent(EmailFormatter.class));
    }

    @Override
    public CommentJsonBean createBean(Comment comment, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        Assertions.notNull("comment", comment);
        return CommentJsonBean.shortBean(comment, this.jiraBaseUrls, this.projectRoleManager, loggedInUser, emailFormatter);
    }

    @Override
    public CommentJsonBean createRenderedBean(Comment comment, ApplicationUser loggedInUser, EmailFormatter emailFormatter) {
        Assertions.notNull("comment", comment);
        IssueRenderContext issueRenderContext = comment.getIssue().getIssueRenderContext();
        FieldLayout layout = this.fieldLayoutManager.getFieldLayout(comment.getIssue());
        FieldLayoutItem fieldLayoutItem = layout.getFieldLayoutItem("comment");
        String rendererType = fieldLayoutItem == null ? null : fieldLayoutItem.getRendererType();
        return CommentJsonBean.renderedShortBean(comment, this.jiraBaseUrls, this.projectRoleManager, this.dateTimeFormatterFactory, this.rendererManager, rendererType, issueRenderContext, loggedInUser, emailFormatter);
    }
}

