/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.issue.field;

import com.atlassian.jira.event.issue.field.AbstractCustomFieldEvent;
import com.atlassian.jira.issue.IssueConstant;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.issuetype.IssueType;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;

public class CustomFieldCreatedEvent
extends AbstractCustomFieldEvent {
    private final Collection<Long> projectIds;
    private final Collection<Long> issueTypeIds;

    public CustomFieldCreatedEvent(@Nonnull CustomField customField) {
        this(customField, null, null);
    }

    public CustomFieldCreatedEvent(@Nonnull CustomField customField, @Nullable List<JiraContextNode> contexts, @Nullable List<IssueType> issueTypes) {
        super(customField);
        Collection idsFromContexts;
        this.projectIds = CollectionUtils.isNotEmpty(contexts) ? (!(idsFromContexts = (Collection)contexts.stream().map(IssueContext::getProjectId).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty() ? idsFromContexts : null) : null;
        this.issueTypeIds = CollectionUtils.isNotEmpty(issueTypes) ? (Collection)issueTypes.stream().filter(Objects::nonNull).map(IssueConstant::getId).map(Long::new).collect(Collectors.toList()) : null;
    }

    public Collection<Long> getProjectIds() {
        return this.projectIds;
    }

    public Collection<Long> getIssueTypeIds() {
        return this.issueTypeIds;
    }
}

