/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.util;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.web.RequestAssetPhaseStore;
import com.atlassian.jira.web.action.util.CalendarLanguageUtil;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import java.util.Locale;

public class CalendarResourceIncluder {
    private static final String CALENDAR_JS_RESOURCE_KEY = "jira.webresources:calendar";
    private static final String CALENDAR_LOCALISATION_RESOURCE_PREFIX = "jira.webresources:calendar-";
    private static final String CALENDAR_LOCALISATION_MOMENT_JS_RESOURCE_KEY = "jira.webresources:calendar-localisation-moment";
    private static final String OBSOLETE_HEBREW_LANGUAGE_CODE = "iw";
    private static final String CURRENT_HEBREW_LANGUAGE_CODE = "he";

    private CalendarLanguageUtil getCalendarLanguageUtil() {
        return ComponentAccessor.getComponent(CalendarLanguageUtil.class);
    }

    WebResourceAssembler getWebsourceAssembler() {
        return ComponentAccessor.getComponent(PageBuilderService.class).assembler();
    }

    private RequestAssetPhaseStore getAssetPhaseStore() {
        return ComponentAccessor.getComponent(RequestAssetPhaseStore.class);
    }

    public boolean hasTranslation(Locale locale) {
        return this.getCalendarLanguageUtil().hasTranslationForLanguage(this.getLanguageCode(locale));
    }

    private void includeCalendarResources(Locale locale) {
        this.getWebsourceAssembler().resources().requireWebResource(this.getAssetPhaseStore().getPhase(), CALENDAR_JS_RESOURCE_KEY);
        this.getWebsourceAssembler().resources().requireWebResource(this.getAssetPhaseStore().getPhase(), CALENDAR_LOCALISATION_RESOURCE_PREFIX + this.getLanguageCode(locale));
        this.getWebsourceAssembler().resources().requireWebResource(this.getAssetPhaseStore().getPhase(), CALENDAR_LOCALISATION_MOMENT_JS_RESOURCE_KEY);
    }

    private String getLanguageCode(Locale locale) {
        if (locale == null) {
            return "unsupported";
        }
        String languageCode = locale.getLanguage();
        if (OBSOLETE_HEBREW_LANGUAGE_CODE.equals(languageCode)) {
            languageCode = CURRENT_HEBREW_LANGUAGE_CODE;
        }
        return languageCode;
    }

    public void includeForLocale(Locale locale) {
        if (this.hasTranslation(locale)) {
            this.includeCalendarResources(locale);
        } else {
            this.includeCalendarResources(null);
        }
    }
}

