/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action;

import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.Users;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;

public class AjaxHeaders {
    private static final String X_AUSERNAME = "X-AUSERNAME";
    private static final String X_PJAX = "X-PJAX";
    private static final String X_REQUESTED_WITH = "X-Requested-With";

    public static boolean requestUsernameMatches(HttpServletRequest request, ApplicationUser user) {
        String username = request.getHeader(X_AUSERNAME);
        if (username == null) {
            return true;
        }
        try {
            username = URLDecoder.decode(username, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (Users.isAnonymous(user)) {
            return "".equals(username);
        }
        return username.equals(user.getName());
    }

    public static boolean isPjaxRequest(HttpServletRequest request) {
        String requestedWithHeader = request.getHeader(X_REQUESTED_WITH);
        return Boolean.parseBoolean(request.getHeader(X_PJAX)) || Objects.nonNull(requestedWithHeader) && requestedWithHeader.equalsIgnoreCase("xmlhttprequest");
    }
}

