/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DelimeterInserter {
    private final String frontDelimeter;
    private final String endDelimeter;
    private final boolean prefixMode;
    private final boolean caseInsensitive;
    private final boolean prefixNonRepeatableMatch;
    private String consideredWhitespace;

    public DelimeterInserter(String frontDelimeter, String endDelimeter) {
        this(frontDelimeter, endDelimeter, true, true);
    }

    public DelimeterInserter(String frontDelimeter, String endDelimeter, boolean prefixMode) {
        this(frontDelimeter, endDelimeter, prefixMode, true);
    }

    public DelimeterInserter(String frontDelimeter, String endDelimeter, boolean prefixMode, boolean caseInsensitive) {
        this(frontDelimeter, endDelimeter, prefixMode, caseInsensitive, false, null);
    }

    private DelimeterInserter(String frontDelimeter, String endDelimeter, boolean prefixMode, boolean caseInsensitive, boolean prefixNonRepeatableMatch, String consideredWhitespace) {
        this.frontDelimeter = Strings.nullToEmpty((String)frontDelimeter);
        this.endDelimeter = Strings.nullToEmpty((String)endDelimeter);
        this.prefixMode = prefixMode;
        this.caseInsensitive = caseInsensitive;
        this.prefixNonRepeatableMatch = prefixNonRepeatableMatch;
        this.consideredWhitespace = consideredWhitespace;
    }

    public String getConsideredWhitespace() {
        return this.consideredWhitespace;
    }

    public void setConsideredWhitespace(String consideredWhitespace) {
        this.consideredWhitespace = consideredWhitespace;
    }

    private boolean isAtStartOfWord(String targetString, int startIndex) {
        if (startIndex == 0) {
            return true;
        }
        char previousCh = targetString.charAt(startIndex - 1);
        return Character.isWhitespace(previousCh) || this.consideredWhitespace != null && this.consideredWhitespace.indexOf(previousCh) != -1;
    }

    public String insert(String targetString, String[] terms) {
        if (targetString == null) {
            throw new IllegalArgumentException("targetString must be non null!");
        }
        String[] stringArray = terms = terms == null ? new String[]{} : terms;
        if (terms.length == 0) {
            return targetString;
        }
        if (this.frontDelimeter.length() == 0 && this.endDelimeter.length() == 0) {
            return targetString;
        }
        ArrayList markers = Lists.newArrayListWithCapacity((int)terms.length);
        Arrays.sort(terms, (o1, o2) -> {
            String s2;
            String s1 = Strings.nullToEmpty((String)o1);
            if (s1.equals(s2 = Strings.nullToEmpty((String)o2))) {
                return 0;
            }
            if (s1.length() == s2.length()) {
                return s1.compareTo(s2);
            }
            return s2.length() - s1.length();
        });
        String matchString = this.caseInsensitive ? targetString.toLowerCase() : targetString;
        for (String term1 : terms) {
            String term = term1;
            if (StringUtils.isBlank((CharSequence)term)) continue;
            term = this.caseInsensitive ? term.toLowerCase() : term;
            this.populateMarkers(markers, matchString, targetString, term);
        }
        markers.sort(Comparator.comparingInt(m -> m.startIndex));
        List<DelimeterMarker> mergedList = this.mergeMarkers(markers);
        return this.markersToString(mergedList, targetString);
    }

    private List<DelimeterMarker> mergeMarkers(List<DelimeterMarker> markers) {
        Iterator<DelimeterMarker> iterator = markers.iterator();
        ArrayList mergedList = Lists.newArrayListWithCapacity((int)markers.size());
        if (iterator.hasNext()) {
            DelimeterMarker currentMarker = iterator.next();
            mergedList.add(currentMarker);
            while (iterator.hasNext()) {
                DelimeterMarker next = iterator.next();
                if (currentMarker.containsSomeOf(next)) {
                    currentMarker.extendToInclude(next);
                    continue;
                }
                currentMarker = next;
                mergedList.add(currentMarker);
            }
        }
        return mergedList;
    }

    private String markersToString(List<DelimeterMarker> markers, String targetString) {
        String subStr;
        StringBuilder sb = new StringBuilder();
        int index = 0;
        for (DelimeterMarker m1 : markers) {
            subStr = targetString.substring(index, m1.getStartIndex());
            sb.append(subStr);
            sb.append(this.frontDelimeter);
            subStr = targetString.substring(m1.getStartIndex(), m1.getEndIndex());
            sb.append(subStr);
            sb.append(this.endDelimeter);
            index = m1.getEndIndex();
            if (index < targetString.length()) continue;
            break;
        }
        if (index < targetString.length()) {
            subStr = targetString.substring(index);
            sb.append(subStr);
        }
        return sb.toString();
    }

    private void populateMarkers(List<DelimeterMarker> markers, String matchString, String targetString, String term) {
        int currentIndex = 0;
        while (true) {
            int startIndex = matchString.indexOf(term, currentIndex);
            int endIndex = startIndex + term.length();
            if (startIndex == -1) break;
            currentIndex = endIndex;
            DelimeterMarker newMarker = new DelimeterMarker(startIndex, endIndex, targetString);
            if (this.prefixMode && this.prefixNonRepeatableMatch && !this.isAtStartOfWord(targetString, startIndex)) continue;
            if (markers.size() == 0) {
                if (this.prefixMode) {
                    if (!this.isAtStartOfWord(targetString, startIndex)) continue;
                    markers.add(newMarker);
                    continue;
                }
                markers.add(newMarker);
                continue;
            }
            boolean addMarker = true;
            for (DelimeterMarker marker : markers) {
                DelimeterMarker m1 = marker;
                if (m1.containsAllOf(newMarker)) {
                    addMarker = false;
                    break;
                }
                if (!m1.containsSomeOf(newMarker)) continue;
                m1.extendToInclude(newMarker);
                addMarker = false;
                break;
            }
            if (!addMarker) continue;
            if (this.prefixMode) {
                if (!this.isAtStartOfWord(matchString, startIndex)) continue;
                markers.add(newMarker);
                continue;
            }
            markers.add(newMarker);
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class DelimeterMarker {
        private int startIndex;
        private int endIndex;
        private final String targetString;

        public DelimeterMarker(int startIndex, int endIndex, String targetString) {
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.targetString = targetString;
        }

        public int getEndIndex() {
            return this.endIndex;
        }

        public int getStartIndex() {
            return this.startIndex;
        }

        public boolean containsAllOf(DelimeterMarker m) {
            return this.startIndex <= m.startIndex && this.endIndex >= m.endIndex;
        }

        public boolean containsSomeOf(DelimeterMarker m) {
            if (m.startIndex < this.startIndex) {
                return this.isWithin(m.endIndex);
            }
            if (m.endIndex > this.endIndex) {
                return this.isWithin(m.startIndex);
            }
            return false;
        }

        private boolean isWithin(int sIndex) {
            return sIndex >= this.startIndex && sIndex <= this.endIndex;
        }

        public void extendToInclude(DelimeterMarker m) {
            if (this.containsSomeOf(m)) {
                this.startIndex = Math.min(this.startIndex, m.startIndex);
                this.endIndex = Math.max(this.endIndex, m.endIndex);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DelimeterMarker");
            sb.append(" si : ");
            sb.append(this.startIndex);
            sb.append(" ei : ");
            sb.append(this.endIndex);
            sb.append(" ( ");
            sb.append(this.targetString.substring(this.startIndex, this.endIndex));
            sb.append(" ) ");
            return sb.toString();
        }
    }

    public static class Builder {
        private String frontDelimeter;
        private String endDelimeter;
        private String consideredWhitespace;
        private boolean prefixMode = true;
        private boolean caseInsensitive = true;
        private boolean prefixNonRepeatableMatch = false;

        private Builder() {
        }

        public Builder setFrontDelimeter(String frontDelimeter) {
            this.frontDelimeter = frontDelimeter;
            return this;
        }

        public Builder setEndDelimeter(String endDelimeter) {
            this.endDelimeter = endDelimeter;
            return this;
        }

        public Builder setConsideredWhitespace(String consideredWhitespace) {
            this.consideredWhitespace = consideredWhitespace;
            return this;
        }

        public Builder setPrefixMode(boolean prefixMode) {
            this.prefixMode = prefixMode;
            return this;
        }

        public Builder setCaseInsensitive(boolean caseInsensitive) {
            this.caseInsensitive = caseInsensitive;
            return this;
        }

        public Builder setPrefixNonRepeatableMatch(boolean prefixNonRepeatableMatch) {
            this.prefixNonRepeatableMatch = prefixNonRepeatableMatch;
            return this;
        }

        public DelimeterInserter build() {
            return new DelimeterInserter(this.frontDelimeter, this.endDelimeter, this.prefixMode, this.caseInsensitive, this.prefixNonRepeatableMatch, this.consideredWhitespace);
        }
    }
}

