/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.jira.user.anonymize.AffectedEntityLink;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;

public class AffectedEntity {
    private final AffectedEntityType type;
    private final String descriptionKey;
    private final Optional<Long> numberOfOccurrences;
    private final Optional<AffectedEntityLink> link;

    private AffectedEntity(@Nonnull AffectedEntityType type, @Nonnull String descriptionKey, Long numberOfOccurrences, AffectedEntityLink link) {
        this.type = Objects.requireNonNull(type);
        this.descriptionKey = Objects.requireNonNull(descriptionKey);
        this.numberOfOccurrences = Optional.ofNullable(numberOfOccurrences);
        this.link = Optional.ofNullable(link);
    }

    @Nonnull
    public AffectedEntityType getType() {
        return this.type;
    }

    @Nonnull
    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    @Nonnull
    public Optional<Long> getNumberOfOccurrences() {
        return this.numberOfOccurrences;
    }

    @Nonnull
    public Optional<AffectedEntityLink> getLink() {
        return this.link;
    }

    public static Builder newBuilder(@Nonnull AffectedEntityType type) {
        return new Builder(type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AffectedEntity that = (AffectedEntity)o;
        return this.type == that.type && Objects.equals(this.descriptionKey, that.descriptionKey) && Objects.equals(this.numberOfOccurrences, that.numberOfOccurrences) && Objects.equals(this.link, that.link);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.descriptionKey, this.numberOfOccurrences, this.link});
    }

    public String toString() {
        return "AffectedEntity{type=" + String.valueOf((Object)this.type) + ", descriptionKey='" + this.descriptionKey + "', numberOfOccurrences=" + String.valueOf(this.numberOfOccurrences) + ", link=" + String.valueOf(this.link) + "}";
    }

    public static class Builder {
        private AffectedEntityType type;
        private String descriptionKey;
        private Long numberOfOccurrences;
        private AffectedEntityLink link;

        private Builder(@Nonnull AffectedEntityType type) {
            this.type = Objects.requireNonNull(type);
        }

        public Builder descriptionKey(@Nonnull String descriptionKey) {
            this.descriptionKey = Objects.requireNonNull(descriptionKey);
            return this;
        }

        public Builder numberOfOccurrences(Long numberOfOccurrences) {
            this.numberOfOccurrences = numberOfOccurrences;
            return this;
        }

        public Builder link(AffectedEntityLink link) {
            this.link = link;
            return this;
        }

        public AffectedEntity build() {
            return new AffectedEntity(this.type, this.descriptionKey, this.numberOfOccurrences, this.link);
        }
    }
}

