/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.field;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.field.FieldOption;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Objects;

@Internal
abstract class AbstractField
implements Field {
    private final String name;
    private final EnumSet<FieldOption> options;

    AbstractField(String name, Collection<FieldOption> options) {
        Assertions.notBlank("name", name);
        Assertions.notNull("options", options);
        this.options = EnumSet.copyOf(options);
        this.name = name;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.options);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isIndexed() {
        return this.options.contains((Object)FieldOption.INDEXED);
    }

    @Override
    public boolean isSortable() {
        return this.options.contains((Object)FieldOption.SORTABLE);
    }

    @Override
    public boolean isStored() {
        return this.options.contains((Object)FieldOption.STORED);
    }

    protected EnumSet<FieldOption> getOptions() {
        return this.options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        AbstractField that = (AbstractField)this.getClass().cast(o);
        return this.isStored() == that.isStored() && this.isIndexed() == that.isIndexed() && this.isSortable() == that.isSortable() && Objects.equals(this.name(), that.name());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.propsToString() + "}";
    }

    protected String propsToString() {
        return "name=" + this.name() + ",options=" + String.valueOf(this.getOptions());
    }
}

