/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.validator;

import com.atlassian.jira.jql.validator.AbstractVersionValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.MessageSetImpl;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.operand.EmptyOperand;
import com.atlassian.query.operand.FunctionOperand;
import com.atlassian.query.operand.MultiValueOperand;
import com.atlassian.query.operand.OperandVisitor;
import com.atlassian.query.operand.SingleValueOperand;
import com.google.common.annotations.VisibleForTesting;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public class WildcardCountValidator {
    private final I18nHelper.BeanFactory beanFactory;

    public WildcardCountValidator(I18nHelper.BeanFactory beanFactory) {
        this.beanFactory = Objects.requireNonNull(beanFactory);
    }

    @Nonnull
    protected MessageSet validate(ApplicationUser searcher, @Nonnull TerminalClause terminalClause) {
        if (!AbstractVersionValidator.LIKE_OPERATORS.contains((Object)terminalClause.getOperator())) {
            return new MessageSetImpl();
        }
        WildcardCountVisitor validator = new WildcardCountVisitor(this.beanFactory.getInstance(searcher));
        return terminalClause.getOperand().accept(validator);
    }

    @VisibleForTesting
    static class WildcardCountVisitor
    implements OperandVisitor<MessageSet> {
        private static final String WILDCARD = "*";
        private static final int WILDCARD_LIMIT = 1;
        private final I18nHelper i18n;

        WildcardCountVisitor(I18nHelper i18n) {
            this.i18n = Objects.requireNonNull(i18n);
        }

        @Override
        public MessageSet visit(EmptyOperand empty) {
            return new MessageSetImpl();
        }

        @Override
        public MessageSet visit(FunctionOperand function) {
            return new MessageSetImpl();
        }

        @Override
        public MessageSet visit(MultiValueOperand multiValue) {
            return new MessageSetImpl();
        }

        @Override
        public MessageSet visit(SingleValueOperand singleValue) {
            MessageSetImpl errors = new MessageSetImpl();
            int wildcardsCount = StringUtils.countMatches((CharSequence)singleValue.getStringValue(), (CharSequence)WILDCARD);
            if (wildcardsCount > 1) {
                errors.addErrorMessage(this.i18n.getText("jira.jql.clause.too.many.wildcards", new Object[]{1, singleValue.getDisplayString()}));
            }
            return errors;
        }
    }
}

