/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.resolver;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.util.RegexpUtils;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;

public class VersionResolver
implements NameResolver<Version> {
    private final VersionManager versionManager;

    public VersionResolver(VersionManager versionManager) {
        this.versionManager = versionManager;
    }

    @Override
    public List<String> getIdsFromName(String name) {
        Assertions.notNull("name", name);
        return (List)this.versionManager.getVersionsByName(name).stream().map(Version::getId).filter(Objects::nonNull).map(String::valueOf).collect(CollectorsUtil.toImmutableList());
    }

    public List<String> getIdsFromNameWildcard(String nameWildcard) {
        String wildcardRegex = RegexpUtils.wildcardToRegex(nameWildcard, true);
        Pattern wildcardPattern = Pattern.compile(wildcardRegex, 2);
        return (List)this.versionManager.getAllVersions().stream().filter(version -> version.getName() != null).filter(version -> wildcardPattern.matcher(version.getName()).find()).map(Version::getId).filter(Objects::nonNull).map(String::valueOf).collect(CollectorsUtil.toImmutableList());
    }

    @Override
    public boolean nameExists(String name) {
        Assertions.notNull("name", name);
        Collection<Version> versions = this.versionManager.getVersionsByName(name);
        return !versions.isEmpty();
    }

    @Override
    public boolean idExists(Long id) {
        Assertions.notNull("id", id);
        return this.versionManager.getVersion(id) != null;
    }

    @Override
    public Version get(Long id) {
        return this.versionManager.getVersion(id);
    }

    @Override
    public Collection<Version> getAll() {
        return this.versionManager.getAllVersions();
    }

    public List<Version> getProjectVersions(Long projectId) {
        return this.versionManager.getVersions(projectId);
    }
}

