/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.jql.operand.QueryLiteral;
import com.atlassian.jira.jql.operator.OperatorClasses;
import com.atlassian.jira.jql.query.AbstractOperatorQueryFactory;
import com.atlassian.jira.jql.query.OperatorSpecificQueryFactory;
import com.atlassian.jira.jql.query.QueryFactoryResult;
import com.atlassian.jira.jql.resolver.IndexInfoResolver;
import com.atlassian.jira.jql.resolver.NameResolver;
import com.atlassian.jira.jql.resolver.VersionResolver;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.util.Predicate;
import com.atlassian.query.operator.Operator;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermInSetQuery;
import org.apache.lucene.util.BytesRef;

public class VersionSpecificRelationalOperatorQueryFactory
extends AbstractOperatorQueryFactory<Version>
implements OperatorSpecificQueryFactory {
    private final VersionResolver versionResolver;
    private final Comparator<? super Version> comparator;
    private final IndexInfoResolver<Version> versionIndexInfoResolver;

    @Deprecated(since="10.2", forRemoval=true)
    public VersionSpecificRelationalOperatorQueryFactory(Comparator<? super Version> comparator, NameResolver<Version> versionNameResolver, IndexInfoResolver<Version> versionIndexInfoResolver) {
        this(versionNameResolver instanceof VersionResolver ? (VersionResolver)versionNameResolver : ComponentAccessor.getComponent(VersionResolver.class), comparator, versionIndexInfoResolver);
    }

    public VersionSpecificRelationalOperatorQueryFactory(VersionResolver versionResolver, Comparator<? super Version> comparator, IndexInfoResolver<Version> versionIndexInfoResolver) {
        super(versionIndexInfoResolver);
        this.versionResolver = versionResolver;
        this.comparator = comparator;
        this.versionIndexInfoResolver = versionIndexInfoResolver;
    }

    @Override
    public QueryFactoryResult createQueryForSingleValue(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        if (!this.handlesOperator(operator)) {
            return QueryFactoryResult.createFalseResult();
        }
        Stream<Version> versions = this.getIndexValues(rawValues).stream().filter(Objects::nonNull).map(Long::valueOf).map(this.versionResolver::get).distinct();
        Stream<String> matchingVersions = versions.flatMap(version -> {
            List<Version> projectVersions = this.versionResolver.getProjectVersions(version.getProjectId());
            Predicate<Version> versionPredicate = operator.getPredicateForValue(this.comparator, version);
            return projectVersions.stream().filter(versionPredicate::evaluate);
        });
        Set matchingVersionIds = matchingVersions.map(this.versionIndexInfoResolver::getIndexedValue).map(BytesRef::new).collect(Collectors.toSet());
        return new QueryFactoryResult((Query)new TermInSetQuery(fieldName, matchingVersionIds));
    }

    @Override
    public QueryFactoryResult createQueryForMultipleValues(String fieldName, Operator operator, List<QueryLiteral> rawValues) {
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public QueryFactoryResult createQueryForEmptyOperand(String fieldName, Operator operator) {
        return QueryFactoryResult.createFalseResult();
    }

    @Override
    public boolean handlesOperator(Operator operator) {
        return OperatorClasses.RELATIONAL_ONLY_OPERATORS.contains((Object)operator);
    }
}

