/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.serializer;

import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.RendererManager;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.StreamingCommentsJsonBean;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.EmailFormatter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingCommentsJsonBeanSerializer
extends JsonSerializer<StreamingCommentsJsonBean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamingCommentsJsonBeanSerializer.class);
    private final CommentService commentService = ComponentAccessor.getComponent(CommentService.class);
    private final JiraBaseUrls jiraBaseUrls = ComponentAccessor.getComponent(JiraBaseUrls.class);
    private final ProjectRoleManager projectRoleManager = ComponentAccessor.getComponent(ProjectRoleManager.class);
    private final EmailFormatter emailFormatter = ComponentAccessor.getComponent(EmailFormatter.class);
    private final DateTimeFormatterFactory dateTimeFormatterFactory = ComponentAccessor.getComponent(DateTimeFormatterFactory.class);
    private final RendererManager rendererManager = ComponentAccessor.getRendererManager();

    public void serialize(StreamingCommentsJsonBean serializableCommentsBean, JsonGenerator jsonGenerator, SerializerProvider provider) throws IOException {
        Long issueId = serializableCommentsBean.getIssue().getId();
        LOGGER.debug("Started serialization of comments for issue id: " + issueId);
        jsonGenerator.writeStartObject();
        jsonGenerator.writeFieldName("comments");
        jsonGenerator.writeStartArray();
        ApplicationUser contextUser = serializableCommentsBean.getContextUser();
        CommentsStream comments = this.getComments(serializableCommentsBean);
        comments.stream().forEach(comment -> {
            CommentJsonBean commentJsonBean = serializableCommentsBean.isRendered() ? this.getRenderedCommentJsonBean(serializableCommentsBean, (Comment)comment, contextUser) : this.getShortCommentJsonBean((Comment)comment, contextUser);
            try {
                jsonGenerator.writeObject((Object)commentJsonBean);
            }
            catch (IOException ioException) {
                throw new RuntimeException("Encountered an error while trying to serialize a comment", ioException);
            }
        });
        jsonGenerator.writeEndArray();
        jsonGenerator.writeNumberField("maxResults", serializableCommentsBean.getLimit());
        jsonGenerator.writeNumberField("total", comments.getTotal());
        jsonGenerator.writeNumberField("startAt", comments.getStartAt());
        jsonGenerator.writeEndObject();
        LOGGER.debug("Finished serialization of comments for issue id: {}, (max: {}, total: {}, startAt: {})", new Object[]{issueId, serializableCommentsBean.getLimit(), comments.getTotal(), comments.getStartAt()});
    }

    @VisibleForTesting
    protected CommentJsonBean getShortCommentJsonBean(Comment comment, ApplicationUser loggedInUser) {
        return CommentJsonBean.shortBean(comment, this.jiraBaseUrls, this.projectRoleManager, loggedInUser, this.emailFormatter);
    }

    @VisibleForTesting
    protected CommentJsonBean getRenderedCommentJsonBean(StreamingCommentsJsonBean serializableCommentsBean, Comment comment, ApplicationUser loggedInUser) {
        return CommentJsonBean.renderedShortBean(comment, this.jiraBaseUrls, this.projectRoleManager, this.dateTimeFormatterFactory, this.rendererManager, serializableCommentsBean.getRendererType(), serializableCommentsBean.getIssue().getIssueRenderContext(), loggedInUser, this.emailFormatter);
    }

    @VisibleForTesting
    private CommentsStream getComments(StreamingCommentsJsonBean bean) {
        return new CommentsStream(this.commentService.streamComments(bean.getContextUser(), bean.getIssue()), bean.getLimit(), bean.isFirstPageRequested());
    }

    private static class CommentsStream {
        private int total;
        private int startAt;
        private final Deque<Comment> queue = new LinkedList<Comment>();

        public CommentsStream(Stream<Comment> stream, int maxResults, boolean firstPage) {
            if (firstPage) {
                stream.forEach(comment -> {
                    ++this.total;
                    if (maxResults >= this.total) {
                        this.queue.addLast((Comment)comment);
                    }
                });
            } else {
                stream.forEach(comment -> {
                    ++this.total;
                    this.queue.addFirst((Comment)comment);
                    if (maxResults < this.total) {
                        this.queue.removeLast();
                    }
                });
            }
            if (!firstPage && maxResults < this.total) {
                this.startAt = this.total - maxResults;
            }
        }

        public Stream<Comment> stream() {
            return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.queue.iterator(), 16), false).onClose(this.queue::clear);
        }

        public int getTotal() {
            return this.total;
        }

        public int getStartAt() {
            return this.startAt;
        }
    }
}

