/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.project.ProjectCategory;
import com.atlassian.jira.util.JiraUrlCodec;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

public class ProjectCategoryJsonBean {
    @JsonProperty
    @Schema(example="http://www.example.com/jira/rest/api/2/projectCategory/10000")
    private String self;
    @JsonProperty
    @Schema(example="10000")
    private String id;
    @JsonProperty
    @Schema(example="This is a project category")
    private String description;
    @JsonProperty
    @Schema(example="My Project Category")
    private String name;

    public String getSelf() {
        return this.self;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public static ProjectCategoryJsonBean bean(ProjectCategory projectCategoryObject, JiraBaseUrls urls) {
        if (projectCategoryObject == null) {
            return null;
        }
        ProjectCategoryJsonBean bean = new ProjectCategoryJsonBean();
        bean.id = projectCategoryObject.getId().toString();
        bean.name = projectCategoryObject.getName();
        bean.description = projectCategoryObject.getDescription();
        bean.self = urls.restApi2BaseUrl() + "projectCategory/" + JiraUrlCodec.encode(bean.getId());
        return bean;
    }
}

