/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.config;

import com.atlassian.annotations.Internal;
import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.issue.context.IssueContext;
import com.atlassian.jira.issue.context.JiraContextNode;
import com.atlassian.jira.issue.context.persistence.FieldConfigContextPersister;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.util.MapUtils;
import com.atlassian.jira.util.collect.CollectionUtil;
import io.atlassian.util.concurrent.LazyReference;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.MultiMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.CompareToBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class FieldConfigSchemeImpl
implements FieldConfigScheme {
    private static final Logger log = LoggerFactory.getLogger(FieldConfigSchemeImpl.class);
    private final Long id;
    private final String name;
    private final String description;
    private final String fieldId;
    private final Map<String, FieldConfig> configs;
    private final FieldConfigContextPersister configContextPersister;
    private final ProjectManager projectManager;
    private final ResettableLazyReference<List<JiraContextNode>> applicableContexts = new ResettableLazyReference<List<JiraContextNode>>(){

        protected List<JiraContextNode> create() {
            if (FieldConfigSchemeImpl.this.configContextPersister == null) {
                return Collections.emptyList();
            }
            ArrayList<JiraContextNode> applicableContexts = new ArrayList<JiraContextNode>(FieldConfigSchemeImpl.this.configContextPersister.getAllContextsForConfigScheme(FieldConfigSchemeImpl.this));
            Collections.sort(applicableContexts);
            return Collections.unmodifiableList(applicableContexts);
        }
    };
    private final LazyReference<MultiMap> configsByConfig = new LazyReference<MultiMap>(){

        protected MultiMap create() {
            return MapUtils.invertMap(FieldConfigSchemeImpl.this.getConfigs());
        }
    };

    public FieldConfigSchemeImpl(Long id, String fieldId, String name, String description, Map<String, FieldConfig> configs, FieldConfigContextPersister configContextPersister) {
        this.id = id;
        this.fieldId = fieldId;
        this.name = StringUtils.abbreviate((String)name, (int)254);
        this.description = description;
        this.configs = configs != null ? CollectionUtil.copyAsImmutableMap(configs) : Collections.emptyMap();
        this.configContextPersister = configContextPersister;
        this.projectManager = ComponentAccessor.getComponent(ProjectManager.class);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Map<String, FieldConfig> getConfigs() {
        return this.configs;
    }

    @Override
    public List<JiraContextNode> getContexts() {
        return (List)this.applicableContexts.get();
    }

    @Override
    public Long getId() {
        return this.id;
    }

    String getFieldId() {
        return this.fieldId;
    }

    @Override
    public ConfigurableField<?> getField() {
        return ComponentAccessor.getFieldManager().getConfigurableField(this.fieldId);
    }

    @Override
    public boolean isInContext(IssueContext issueContext) {
        List<JiraContextNode> contexts = this.getContexts();
        if (contexts != null) {
            for (JiraContextNode contextNode : contexts) {
                if (!contextNode.isInContext(issueContext)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Project> getAssociatedProjectObjects() {
        if (this.isEnabled()) {
            List<Long> projectIds = this.getAssociatedProjectIds();
            return this.projectManager.convertToProjectObjects(projectIds);
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<Long> getAssociatedProjectIds() {
        if (this.isEnabled()) {
            LinkedList<Long> list = new LinkedList<Long>();
            for (JiraContextNode contextNode : this.getContexts()) {
                Long projectId = contextNode.getProjectId();
                if (projectId == null) continue;
                list.add(projectId);
            }
            return list;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<IssueType> getAssociatedIssueTypes() {
        if (this.configs == null || this.configs.isEmpty() || !this.isEnabled()) {
            return Collections.emptyList();
        }
        ConstantsManager constantsManager = ComponentAccessor.getConstantsManager();
        return (Collection)this.configs.keySet().stream().map(constantsManager::getIssueType).collect(CollectorsUtil.toNewArrayListWithSizeOf(this.configs));
    }

    @Override
    @Nonnull
    public Collection<String> getAssociatedIssueTypeIds() {
        return this.configs != null && this.isEnabled() ? this.configs.keySet() : Collections.emptyList();
    }

    @Override
    public boolean isGlobal() {
        return this.isAllProjects() && this.isAllIssueTypes();
    }

    @Override
    public boolean isAllProjects() {
        List<JiraContextNode> contexts = this.getContexts();
        List<Long> projectIdsFromContexts = contexts.stream().map(IssueContext::getProjectId).filter(Objects::nonNull).collect(Collectors.toList());
        if (projectIdsFromContexts.size() < contexts.size()) {
            return true;
        }
        List<Project> projects = this.projectManager.convertToProjectObjects(projectIdsFromContexts);
        return projects.size() < projectIdsFromContexts.size();
    }

    @Override
    public boolean isAllIssueTypes() {
        Collection<IssueType> issueTypes = this.getAssociatedIssueTypes();
        return issueTypes != null && issueTypes.contains(null);
    }

    @Override
    public boolean isEnabled() {
        return !this.getContexts().isEmpty();
    }

    @Override
    public boolean isBasicMode() {
        MultiMap configsByConfig = this.getConfigsByConfig();
        return configsByConfig == null || configsByConfig.size() <= 1;
    }

    @Override
    public MultiMap getConfigsByConfig() {
        return (MultiMap)this.configsByConfig.get();
    }

    @Override
    @Nullable
    public FieldConfig getOneAndOnlyConfig() {
        MultiMap configsByConfig = this.getConfigsByConfig();
        if (configsByConfig != null) {
            if (configsByConfig.size() == 1) {
                return (FieldConfig)configsByConfig.keySet().iterator().next();
            }
            log.warn("There is not exactly one config for this scheme ({}). Configs are {}.", (Object)this.id, (Object)configsByConfig);
        }
        return null;
    }

    FieldConfigContextPersister getFieldConfigContextPersister() {
        return this.configContextPersister;
    }

    public boolean equals(Object o) {
        return this == o || o instanceof FieldConfigScheme && this.equals((FieldConfigScheme)o);
    }

    private boolean equals(@Nonnull FieldConfigScheme other) {
        return Objects.equals(this.id, other.getId()) && Objects.equals(this.name, other.getName()) && Objects.equals(this.description, other.getDescription());
    }

    public int compareTo(Object obj) {
        FieldConfigScheme o = (FieldConfigScheme)obj;
        return new CompareToBuilder().append((Object)this.id, (Object)o.getId()).append((Object)this.name, (Object)o.getName()).append((Object)this.description, (Object)o.getDescription()).toComparison();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description);
    }
}

