/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.view;

import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.view.CustomFieldParams;
import com.atlassian.jira.issue.fields.CustomField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.ofbiz.core.entity.GenericEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFieldParamsImpl
implements CustomFieldParams {
    private static final Logger log = LoggerFactory.getLogger(CustomFieldParamsImpl.class);
    private final Map<String, Collection<String>> parameterMap = new HashMap<String, Collection<String>>();
    private CustomField customField;

    public CustomFieldParamsImpl() {
    }

    public CustomFieldParamsImpl(CustomField customField) {
        this(customField, Collections.emptyList());
    }

    public CustomFieldParamsImpl(CustomField customField, Object paramsObject) {
        if (paramsObject instanceof CustomFieldParams) {
            CustomFieldParams params = (CustomFieldParams)paramsObject;
            this.deepCopy(params.getKeysAndValues());
        } else if (paramsObject instanceof Map && !(paramsObject instanceof GenericEntity)) {
            Map params = (Map)paramsObject;
            this.deepCopy(params);
        } else if (paramsObject instanceof Collection) {
            this.parameterMap.put(null, new ArrayList((Collection)paramsObject));
        } else if (paramsObject != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(paramsObject);
            this.parameterMap.put(null, list);
        } else {
            log.debug("CustomFieldParamsImpl received a null object in constructor");
        }
        this.customField = customField;
    }

    private void deepCopy(Map params) {
        Set entries = params.entrySet();
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry1;
            Map.Entry entry = entry1 = iterator.next();
            String key = (String)entry.getKey();
            Object values = entry.getValue();
            if (values instanceof Collection) {
                this.parameterMap.put(key, new ArrayList((Collection)values));
                continue;
            }
            ArrayList list = new ArrayList();
            list.add(values);
            this.parameterMap.put(key, list);
        }
    }

    @Override
    public Set<String> getAllKeys() {
        return this.parameterMap.keySet();
    }

    @Override
    public CustomField getCustomField() {
        return this.customField;
    }

    @Override
    public void setCustomField(CustomField customField) {
        this.customField = customField;
    }

    @Override
    public Collection<String> getValuesForKey(@Nullable String key) {
        return this.parameterMap.get(key);
    }

    @Override
    public Object getFirstValueForKey(@Nullable String key) {
        Collection<String> c = this.getValuesForKey(key);
        if (c != null && !c.isEmpty()) {
            return c.iterator().next();
        }
        return null;
    }

    @Override
    public Collection getValuesForNullKey() {
        return this.getValuesForKey(null);
    }

    @Override
    public Collection getAllValues() {
        ArrayList<String> allValues = new ArrayList<String>();
        for (Collection<String> values : this.parameterMap.values()) {
            allValues.addAll(values);
        }
        return allValues;
    }

    @Override
    public String getQueryString() {
        String customFieldId = this.getCustomField().getId();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Collection<String>> entry : this.parameterMap.entrySet()) {
            String key = entry.getKey();
            Collection<String> values = entry.getValue();
            if (values == null) continue;
            for (String value : values) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                if (key != null) {
                    sb.append(customFieldId).append(":").append(key);
                } else {
                    sb.append(customFieldId);
                }
                sb.append("=").append(value);
            }
        }
        return sb.toString();
    }

    public void addValue(String key, Collection<String> values) {
        this.parameterMap.put(key, values);
    }

    public void addValue(Collection<String> values) {
        this.parameterMap.put(null, values);
    }

    @Override
    public void put(String key, Collection<String> value) {
        this.addValue(key, value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomFieldParams)) {
            return false;
        }
        CustomFieldParams customFieldParams = (CustomFieldParams)o;
        if (this.customField == null && customFieldParams.getCustomField() != null) {
            return false;
        }
        if (this.customField != null && !this.customField.equals(customFieldParams.getCustomField())) {
            return false;
        }
        return this.parameterMap.equals(customFieldParams.getKeysAndValues());
    }

    public int hashCode() {
        int result = this.parameterMap.hashCode();
        result = 29 * result + this.customField.hashCode();
        return result;
    }

    public String toString() {
        return "CustomFieldParams: " + String.valueOf(this.customField) + ".  Params: " + String.valueOf(this.parameterMap) + ".";
    }

    @Override
    public boolean isEmpty() {
        if (!this.parameterMap.isEmpty()) {
            for (Collection<String> element : this.parameterMap.values()) {
                if (element.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean contains(String key, String value) {
        Collection<String> c = this.getValuesForKey(key);
        if (c != null && !c.isEmpty()) {
            return c.contains(value);
        }
        return false;
    }

    @Override
    public void transformObjectsToStrings() {
        Transformer toStringTransformer = new Transformer(){

            public Object transform(Object input) {
                return CustomFieldParamsImpl.this.getCustomField().getCustomFieldType().getStringFromSingularObject(input);
            }
        };
        CustomFieldParamsImpl.transformMultiMap(toStringTransformer, this.parameterMap);
    }

    @Override
    public void transformStringsToObjects() {
        Transformer toObjectTransformer = new Transformer(){

            public Object transform(Object input) {
                try {
                    return CustomFieldParamsImpl.this.getCustomField().getCustomFieldType().getSingularObjectFromString((String)input);
                }
                catch (FieldValidationException e) {
                    log.info("Failed to convert from string to singular object", (Throwable)e);
                    return null;
                }
            }
        };
        CustomFieldParamsImpl.transformMultiMap(toObjectTransformer, this.parameterMap);
    }

    public static void transformMultiMap(Transformer transformer, Map parameterMap) {
        Collection values = parameterMap.values();
        for (Object value : values) {
            try {
                Collection collection = (Collection)value;
                CollectionUtils.transform((Collection)collection, (Transformer)transformer);
            }
            catch (RuntimeException e) {
                log.error("Exception occurred during transformation of Params. State may be inconsistent", (Throwable)e);
            }
        }
    }

    @Override
    public void transform(Transformer transformer) {
        CustomFieldParamsImpl.transformMultiMap(transformer, this.parameterMap);
    }

    @Override
    public Object getFirstValueForNullKey() {
        return this.getFirstValueForKey(null);
    }

    @Override
    public Map getKeysAndValues() {
        return new HashMap<String, Collection<String>>(this.parameterMap);
    }

    @Override
    public void remove(String key) {
        this.parameterMap.remove(key);
    }

    @Override
    public boolean containsKey(String key) {
        return this.parameterMap.containsKey(key);
    }
}

