/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.nullability.ReturnValuesAreNonnullByDefault;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.user.ApplicationUser;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nullable;

@ExperimentalApi
@ReturnValuesAreNonnullByDefault
public class CommentSearchParameters {
    private final Issue issue;
    private final ApplicationUser user;
    private final Date date;
    private final Long commentId;
    private final SearchDirection searchDirection;
    private final boolean returnOldest;
    private final Integer limit;

    public CommentSearchParameters(Issue issue, ApplicationUser user, Date date, Long commentId, SearchDirection searchDirection, boolean returnOldest, Integer limit) {
        this.issue = issue;
        this.user = user;
        this.date = date;
        this.commentId = commentId;
        this.searchDirection = searchDirection;
        this.returnOldest = returnOldest;
        this.limit = limit;
    }

    public Issue getIssue() {
        return this.issue;
    }

    @Nullable
    public ApplicationUser getUser() {
        return this.user;
    }

    @Nullable
    public Date getDate() {
        return this.date;
    }

    @Nullable
    public Long getCommentId() {
        return this.commentId;
    }

    @Nullable
    public SearchDirection getSearchDirection() {
        return this.searchDirection;
    }

    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean returnOldest() {
        return this.returnOldest;
    }

    @ExperimentalApi
    public static enum SearchDirection {
        OLDER,
        NEWER,
        BOTH;

    }

    public static class Builder {
        private Issue issue;
        private ApplicationUser user;
        private Date date;
        private Long commentId;
        private SearchDirection searchDirection;
        private Integer limit;
        private boolean returnOldest;

        private Builder() {
        }

        public Builder issue(Issue issue) {
            this.issue = Objects.requireNonNull(issue);
            return this;
        }

        public Builder user(ApplicationUser user) {
            this.user = user;
            return this;
        }

        public Builder searchByDate(Date date, SearchDirection direction) {
            if (this.commentId != null) {
                throw new IllegalStateException("Cannot search by comment and date at the same time");
            }
            this.date = Objects.requireNonNull(date);
            this.searchDirection = Objects.requireNonNull(direction);
            return this;
        }

        public Builder searchByComment(long id, SearchDirection direction) {
            if (this.date != null) {
                throw new IllegalStateException("Cannot search by comment and date at the same time");
            }
            this.commentId = id;
            this.searchDirection = Objects.requireNonNull(direction);
            return this;
        }

        public Builder searchForTheOldestOrNewest(SearchDirection direction) {
            if (this.date != null || this.commentId != null) {
                throw new IllegalStateException("Cannot search by direction and date or comment at the same time");
            }
            this.searchDirection = Objects.requireNonNull(direction);
            return this;
        }

        public Builder returnOldest() {
            this.returnOldest = true;
            return this;
        }

        public Builder returnNewest() {
            this.returnOldest = false;
            return this;
        }

        public Builder limit(int limit) {
            this.limit = limit;
            return this;
        }

        public Builder noLimit() {
            this.limit = null;
            return this;
        }

        public CommentSearchParameters build() {
            return new CommentSearchParameters(Objects.requireNonNull(this.issue, "issue"), this.user, this.date, this.commentId, this.searchDirection, this.returnOldest, this.limit);
        }
    }
}

