/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.event.project;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.project.Project;
import javax.annotation.Nonnull;

public class ProjectAvatarUpdateEvent {
    private final Project project;
    private final Long newAvatarId;

    @Internal
    public ProjectAvatarUpdateEvent(@Nonnull Project project, @Nonnull Long newAvatarId) {
        this.project = project;
        this.newAvatarId = newAvatarId;
    }

    public Project getProject() {
        return this.project;
    }

    public Long getOldAvatarId() {
        return this.project.getAvatar().getId();
    }

    public Long getNewAvatarId() {
        return this.newAvatarId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectAvatarUpdateEvent that = (ProjectAvatarUpdateEvent)o;
        if (this.newAvatarId != null ? !this.newAvatarId.equals(that.newAvatarId) : that.newAvatarId != null) {
            return false;
        }
        return !(this.project != null ? !this.project.equals(that.project) : that.project != null);
    }

    public int hashCode() {
        int result = this.project != null ? this.project.hashCode() : 0;
        result = 31 * result + (this.newAvatarId != null ? this.newAvatarId.hashCode() : 0);
        return result;
    }
}

