/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config.properties;

import com.atlassian.annotations.Internal;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.builder.ToStringBuilder;

@Internal
public class ApplicationProperty {
    @Nonnull
    private final String key;
    @Nonnull
    private final Type type;
    @Nullable
    private final Object value;

    public ApplicationProperty(String key, Type type, @Nullable Object value) {
        this.key = key;
        this.type = type;
        this.value = value;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    @Nonnull
    public Type getType() {
        return this.type;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    @Nullable
    public Boolean getBoolean() {
        return this.getValue(Boolean.class, Type.BOOLEAN);
    }

    @Nullable
    public Date getDate() {
        return this.getValue(Date.class, Type.DATE);
    }

    @Nullable
    public Double getDouble() {
        return this.getValue(Double.class, Type.DECIMAL);
    }

    @Nullable
    public Long getLong() {
        return this.getValue(Long.class, Type.INTEGER);
    }

    @Nullable
    public String getString() {
        return this.getValue(String.class, Type.STRING, Type.TEXT);
    }

    @Nullable
    public String getText() {
        return this.getString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApplicationProperty property = (ApplicationProperty)o;
        return Objects.equals(this.key, property.key) && this.type == property.type && Objects.equals(this.value, property.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.type, this.value});
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("key", (Object)this.key).append("type", (Object)this.type).append("value", this.value).toString();
    }

    @Nullable
    private <T> T getValue(Class<T> clazz, Type ... types) {
        for (Type t : types) {
            if (this.type != t) continue;
            return clazz.cast(this.value);
        }
        throw new InvalidTypeException();
    }

    public static enum Type {
        BOOLEAN,
        DATE,
        DECIMAL,
        INTEGER,
        STRING,
        TEXT;

    }

    static class InvalidTypeException
    extends RuntimeException {
        InvalidTypeException() {
        }
    }
}

