/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.index;

import com.atlassian.jira.task.TaskProgressSink;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.johnson.event.Event;
import javax.annotation.Nonnull;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class Contexts {
    private static final String REINDEX_PERCENTAGE = "admin.indexing.percent.complete";
    private static final String REINDEX_CURRENT = "admin.indexing.current.index";
    private static final String REINDEXING = "Re-indexing is {0}% complete. Current index: {1}";

    public static Context percentageLogger(Sized sized, Logger logger) {
        return Contexts.builder().sized(sized).log(logger, REINDEXING, Level.INFO).build();
    }

    public static Context percentageReporter(@Nonnull Sized sized, @Nonnull TaskProgressSink sink, @Nonnull I18nHelper i18n, @Nonnull Logger logger) {
        return Contexts.builder().sized(sized).progress(sink, i18n, REINDEX_PERCENTAGE, REINDEX_CURRENT).log(logger, REINDEXING, Level.INFO).build();
    }

    public static Context percentageReporter(@Nonnull Sized sized, @Nonnull TaskProgressSink sink, @Nonnull I18nHelper i18n, @Nonnull Logger logger, @Nonnull Event event) {
        return Contexts.builder().sized(sized).event(event).progress(sink, i18n, REINDEX_PERCENTAGE, REINDEX_CURRENT).log(logger, REINDEXING, Level.INFO).build();
    }

    private static Context.Builder builder() {
        return com.atlassian.jira.task.context.Contexts.builder();
    }
}

