/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.util.MessageSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

@Internal
public abstract class AbstractMessageSet
implements MessageSet {
    private final Map<String, MessageSet.MessageLink> errors;
    private final Map<String, MessageSet.MessageLink> warnings;
    private final Set<String> errorsInEnglish;
    private final Set<String> warningsInEnglish;

    protected AbstractMessageSet(Map<String, MessageSet.MessageLink> errors, Map<String, MessageSet.MessageLink> warnings, Set<String> errorsInEnglish, Set<String> warningsInEnglish) {
        this.errors = errors;
        this.warnings = warnings;
        this.errorsInEnglish = errorsInEnglish;
        this.warningsInEnglish = warningsInEnglish;
    }

    @Override
    public Set<String> getErrorMessages() {
        return Collections.unmodifiableSet(this.errors.keySet());
    }

    @Override
    public Set<String> getErrorMessagesInEnglish() {
        return Collections.unmodifiableSet(this.errorsInEnglish);
    }

    @Override
    public Set<String> getWarningMessages() {
        return Collections.unmodifiableSet(this.warnings.keySet());
    }

    @Override
    public Set<String> getWarningMessagesInEnglish() {
        return Collections.unmodifiableSet(this.warningsInEnglish);
    }

    @Override
    public boolean hasAnyErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public boolean hasAnyWarnings() {
        return !this.warnings.isEmpty();
    }

    @Override
    public boolean hasAnyMessages() {
        return this.hasAnyErrors() || this.hasAnyWarnings();
    }

    @Override
    public MessageSet.MessageLink getLinkForError(String errorMsg) {
        return this.errors.get(errorMsg);
    }

    @Override
    public MessageSet.MessageLink getLinkForWarning(String warningMsg) {
        return this.warnings.get(warningMsg);
    }

    @Override
    public void addMessageSet(MessageSet messageSet) {
        if (messageSet != null) {
            for (String errorMsg : messageSet.getErrorMessages()) {
                this.errors.put(errorMsg, messageSet.getLinkForError(errorMsg));
            }
            for (String warningMsg : messageSet.getWarningMessages()) {
                this.warnings.put(warningMsg, messageSet.getLinkForError(warningMsg));
            }
            for (String errorMsgInEng : messageSet.getErrorMessagesInEnglish()) {
                this.errorsInEnglish.add(errorMsgInEng);
            }
            for (String warningMsgInEng : messageSet.getWarningMessagesInEnglish()) {
                this.warningsInEnglish.add(warningMsgInEng);
            }
        }
    }

    @Override
    public void addMessage(MessageSet.Level level, String errorMessage) {
        switch (level) {
            case ERROR: {
                this.addErrorMessage(errorMessage);
                break;
            }
            case WARNING: {
                this.addWarningMessage(errorMessage);
                break;
            }
            default: {
                throw new RuntimeException("Unrecognised MessageSet Level: " + level);
            }
        }
    }

    @Override
    public void addMessage(MessageSet.Level level, String errorMessage, MessageSet.MessageLink link) {
        switch (level) {
            case ERROR: {
                this.addErrorMessage(errorMessage, link);
                break;
            }
            case WARNING: {
                this.addWarningMessage(errorMessage, link);
                break;
            }
            default: {
                throw new RuntimeException("Unrecognised MessageSet Level: " + level);
            }
        }
    }

    @Override
    public void addErrorMessage(String errorMessage) {
        this.addErrorMessage(errorMessage, null);
    }

    @Override
    public void addErrorMessage(String errorMessage, MessageSet.MessageLink link) {
        this.errors.put(errorMessage, link);
    }

    @Override
    public void addErrorMessageInEnglish(String errorMessage) {
        this.errorsInEnglish.add(errorMessage);
    }

    @Override
    public void addWarningMessage(String warningMessage) {
        this.addWarningMessage(warningMessage, null);
    }

    @Override
    public void addWarningMessage(String warningMessage, MessageSet.MessageLink link) {
        this.warnings.put(warningMessage, link);
    }

    @Override
    public void addWarningMessageInEnglish(String warningMessage) {
        this.warningsInEnglish.add(warningMessage);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMessageSet that = (AbstractMessageSet)o;
        if (!this.errors.equals(that.errors)) {
            return false;
        }
        if (!this.errorsInEnglish.equals(that.errorsInEnglish)) {
            return false;
        }
        if (!this.warnings.equals(that.warnings)) {
            return false;
        }
        return this.warningsInEnglish.equals(that.warningsInEnglish);
    }

    public int hashCode() {
        int result = this.errors.hashCode();
        result = 31 * result + this.warnings.hashCode();
        result = 31 * result + this.errorsInEnglish.hashCode();
        result = 31 * result + this.warningsInEnglish.hashCode();
        return result;
    }

    public String toString() {
        return "Errors: " + this.getErrorMessages() + ", Warnings: " + this.getWarningMessages();
    }
}

