/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.index;

import com.atlassian.jira.search.index.DeleteRequest;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public final class DeleteBulkRequest {
    private final Set<DeleteRequest> deleteRequests;

    private DeleteBulkRequest(Builder builder) {
        this.deleteRequests = builder.bulkBuilder.build();
    }

    public Set<DeleteRequest> getBulk() {
        return this.deleteRequests;
    }

    public int size() {
        return this.deleteRequests.size();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableSet.Builder<DeleteRequest> bulkBuilder = ImmutableSet.builder();

        public Builder put(DeleteRequest deleteRequest) {
            this.bulkBuilder.add((Object)deleteRequest);
            return this;
        }

        public Builder put(String documentId) {
            this.bulkBuilder.add((Object)DeleteRequest.builder(documentId).build());
            return this;
        }

        public DeleteBulkRequest build() {
            return new DeleteBulkRequest(this);
        }

        public Builder putAll(Set<DeleteRequest> deleteRequests) {
            this.bulkBuilder.addAll(deleteRequests);
            return this;
        }

        public Builder putAll(Iterable<String> bulk) {
            bulk.forEach(documentId -> this.bulkBuilder.add((Object)DeleteRequest.builder(documentId).build()));
            return this;
        }
    }
}

