/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.values;

import com.atlassian.annotations.PublicSpi;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

@PublicSpi
public interface ClauseValuesGenerator {
    public Results getPossibleValues(ApplicationUser var1, String var2, String var3, int var4);

    public static class Result {
        private final String value;
        private final String[] displayNameParts;

        public Result(String value) {
            this.value = Assertions.notNull("value", value);
            this.displayNameParts = new String[]{value};
        }

        public Result(String value, String displayName) {
            this.value = Assertions.notNull("value", value);
            this.displayNameParts = new String[]{Assertions.notNull("displayName", displayName)};
        }

        public Result(String value, String[] displayNameParts) {
            this.value = Assertions.notNull("value", value);
            this.displayNameParts = Assertions.notNull("displayNameParts", displayNameParts);
        }

        public String getValue() {
            return this.value;
        }

        public String[] getDisplayNameParts() {
            return this.displayNameParts;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            if (!Arrays.equals(this.displayNameParts, result.displayNameParts)) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(result.value) : result.value != null);
        }

        public int hashCode() {
            int result = this.value != null ? this.value.hashCode() : 0;
            result = 31 * result + (this.displayNameParts != null ? Arrays.hashCode(this.displayNameParts) : 0);
            return result;
        }

        public String toString() {
            return "Result{value='" + this.value + "', displayNameParts=" + (this.displayNameParts == null ? null : Arrays.asList(this.displayNameParts)) + "}";
        }
    }

    public static class Results {
        private final List<Result> results;

        public Results(List<Result> results) {
            this.results = new ArrayList<Result>((Collection)Assertions.notNull("results", results));
        }

        public List<Result> getResults() {
            return Collections.unmodifiableList(this.results);
        }
    }
}

