/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.jql.query;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.query.operator.Operator;
import java.util.List;
import org.apache.lucene.search.Query;

public abstract class AbstractRangeQueryFactory<T, U> {
    protected final Function<T, U> valueFactory;

    protected AbstractRangeQueryFactory(Function<T, U> valueFactory) {
        this.valueFactory = Assertions.notNull("valueFactory", valueFactory);
    }

    Query get(Operator operator, String fieldName, T value) {
        switch (operator) {
            case LESS_THAN: {
                return this.handleLessThan(fieldName, value);
            }
            case LESS_THAN_EQUALS: {
                return this.handleLessThanEquals(fieldName, value);
            }
            case GREATER_THAN: {
                return this.handleGreaterThan(fieldName, value);
            }
            case GREATER_THAN_EQUALS: {
                return this.handleGreaterThanEquals(fieldName, value);
            }
        }
        throw new IllegalArgumentException("Unhandled Operator: " + operator);
    }

    Query get(Operator operator, String fieldName, List<T> values) {
        if (operator == Operator.DURING) {
            if (values.get(0) == null) {
                return this.handleLessThanEquals(fieldName, values.get(1));
            }
            if (values.get(1) == null) {
                return this.handleGreaterThanEquals(fieldName, values.get(0));
            }
            return this.handleDuring(fieldName, values.get(0), values.get(1));
        }
        throw new IllegalArgumentException("Unhandled Operator: " + operator);
    }

    abstract Query handleLessThan(String var1, T var2);

    abstract Query handleLessThanEquals(String var1, T var2);

    abstract Query handleGreaterThan(String var1, T var2);

    abstract Query handleGreaterThanEquals(String var1, T var2);

    abstract Query handleDuring(String var1, T var2, T var3);
}

