/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.search;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.issue.search.searchers.IssueSearcher;
import com.atlassian.jira.jql.ClauseHandler;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

@PublicApi
public final class SearchHandler {
    private final List<ClauseRegistration> clauseRegistrations;
    private final List<FieldIndexer> fieldIndexers;
    private final SearcherRegistration searcherRegistration;

    public SearchHandler(List<FieldIndexer> fieldIndexers, SearcherRegistration searcherRegistration, List<ClauseRegistration> clauseRegistrations) {
        this.clauseRegistrations = CollectionUtil.copyAsImmutableList((Collection)Assertions.containsNoNulls("clauseRegistrations", clauseRegistrations));
        this.fieldIndexers = CollectionUtil.copyAsImmutableList((Collection)Assertions.containsNoNulls("fieldIndexers", fieldIndexers));
        this.searcherRegistration = searcherRegistration;
    }

    public SearchHandler(List<FieldIndexer> fieldIndexers, SearcherRegistration searcherRegistration) {
        this(fieldIndexers, searcherRegistration, Collections.emptyList());
    }

    public List<FieldIndexer> getIndexers() {
        return this.fieldIndexers;
    }

    public List<ClauseRegistration> getClauseRegistrations() {
        return this.clauseRegistrations;
    }

    public SearcherRegistration getSearcherRegistration() {
        return this.searcherRegistration;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchHandler that = (SearchHandler)o;
        if (!this.clauseRegistrations.equals(that.clauseRegistrations)) {
            return false;
        }
        if (!this.fieldIndexers.equals(that.fieldIndexers)) {
            return false;
        }
        return !(this.searcherRegistration != null ? !this.searcherRegistration.equals(that.searcherRegistration) : that.searcherRegistration != null);
    }

    public int hashCode() {
        int result = this.clauseRegistrations.hashCode();
        result = 31 * result + this.fieldIndexers.hashCode();
        result = 31 * result + (this.searcherRegistration != null ? this.searcherRegistration.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static class SearcherRegistration {
        private final IssueSearcher<?> searcher;
        private final List<ClauseRegistration> clauseRegistrations;

        public SearcherRegistration(IssueSearcher<?> searcher, ClauseHandler clauseHandler) {
            this(searcher, new ClauseRegistration(Assertions.notNull("clauseHandler", clauseHandler)));
        }

        public SearcherRegistration(IssueSearcher<?> searcher, List<ClauseRegistration> clauseRegistrations) {
            this.searcher = Assertions.notNull("searcher", searcher);
            this.clauseRegistrations = CollectionUtil.copyAsImmutableList((Collection)Assertions.containsNoNulls("clauseRegistrations", clauseRegistrations));
        }

        public SearcherRegistration(IssueSearcher<?> searcher, ClauseRegistration clauseRegistration) {
            this(searcher, Collections.singletonList(Assertions.notNull("clauseRegistration", clauseRegistration)));
        }

        public IssueSearcher<?> getIssueSearcher() {
            return this.searcher;
        }

        public List<ClauseRegistration> getClauseHandlers() {
            return this.clauseRegistrations;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SearcherRegistration that = (SearcherRegistration)o;
            if (!this.clauseRegistrations.equals(that.clauseRegistrations)) {
                return false;
            }
            return this.searcher.equals(that.searcher);
        }

        public int hashCode() {
            int result = this.searcher.hashCode();
            result = 31 * result + this.clauseRegistrations.hashCode();
            return result;
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }

    public static class ClauseRegistration {
        private final ClauseHandler handlers;

        public ClauseRegistration(ClauseHandler handler) {
            this.handlers = Assertions.notNull("handler", handler);
        }

        public ClauseHandler getHandler() {
            return this.handlers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClauseRegistration that = (ClauseRegistration)o;
            return this.handlers.equals(that.handlers);
        }

        public int hashCode() {
            return this.handlers.hashCode();
        }

        public String toString() {
            return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
        }
    }
}

