/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.admin.contextproviders;

import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import java.util.Map;

public class AddUserCountProvider
implements ContextProvider {
    private final JiraAuthenticationContext authenticationContext;
    private final VelocityRequestContextFactory requestContextFactory;
    private final UserUtil userUtil;

    public AddUserCountProvider(JiraAuthenticationContext authenticationContext, VelocityRequestContextFactory requestContextFactory, UserUtil userUtil) {
        this.authenticationContext = authenticationContext;
        this.requestContextFactory = requestContextFactory;
        this.userUtil = userUtil;
    }

    public void init(Map<String, String> stringStringMap) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> params) {
        I18nHelper i18n = this.authenticationContext.getI18nHelper();
        MapBuilder builder = MapBuilder.newBuilder();
        String baseUrl = this.requestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        String viewLicense = baseUrl + "/secure/admin/ViewLicense!default.jspa";
        String viewLicenseHref = String.format("<a href=\"%s\">", viewLicense);
        builder.add((Object)"limitWarningHtml", (Object)i18n.getText("admin.adduser.user.limit.warning", viewLicenseHref, "</a>"));
        builder.add((Object)"userCountHtml", (Object)i18n.getText("admin.userbrowser.how.many.users", String.valueOf(this.userUtil.getTotalUserCount()), String.valueOf(this.userUtil.getActiveUserCount())));
        builder.add((Object)"hasReachedUserLimit", (Object)(!this.userUtil.canActivateNumberOfUsers(1) ? 1 : 0));
        builder.toMap();
        return builder.toMap();
    }
}

