/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.customfields.OperationContextImpl;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItem;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderLayoutItemImpl;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderTab;
import com.atlassian.jira.issue.fields.screen.FieldScreenRenderer;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.operation.WorkflowIssueOperationImpl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowProgressAware;
import com.atlassian.jira.workflow.WorkflowTransitionUtil;
import com.opensymphony.workflow.loader.ActionDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.ofbiz.core.entity.GenericValue;

public class WorkflowTransitionUtilImpl
implements WorkflowProgressAware,
WorkflowTransitionUtil {
    private final ErrorCollection errorCollection;
    private final JiraAuthenticationContext authenticationContext;
    private final WorkflowManager workflowManager;
    private final PermissionManager permissionManager;
    private MutableIssue issue;
    private GenericValue project;
    private int actionId;
    private ActionDescriptor actionDescriptor;
    private Map params;
    private String username;
    private FieldScreenRenderer fieldScreenRenderer;
    private FieldScreenRendererFactory fieldScreenRendererFactory;
    private final CommentService commentService;
    private Map additionalInputs = new HashMap();

    public WorkflowTransitionUtilImpl(JiraAuthenticationContext authenticationContext, WorkflowManager workflowManager, PermissionManager permissionManager, FieldScreenRendererFactory fieldScreenRendererFactory, CommentService commentService) {
        this.authenticationContext = authenticationContext;
        this.workflowManager = workflowManager;
        this.permissionManager = permissionManager;
        this.fieldScreenRendererFactory = fieldScreenRendererFactory;
        this.commentService = commentService;
        this.errorCollection = new SimpleErrorCollection();
        this.params = new HashMap();
        this.username = this.getRemoteUser() == null ? null : this.getRemoteUser().getName();
    }

    @Override
    public MutableIssue getIssue() {
        return this.issue;
    }

    @Override
    public void setIssue(MutableIssue issue) {
        this.issue = issue;
    }

    private String getComment() {
        return (String)this.params.get("comment");
    }

    private String getCommentLevel() {
        return (String)this.params.get("commentLevel");
    }

    private String getCommentRoleLevel() {
        return (String)this.params.get("roleLevel");
    }

    @Override
    public GenericValue getProject() {
        if (this.project == null) {
            this.project = this.issue.getProject();
        }
        return this.project;
    }

    @Override
    public User getRemoteUser() {
        return this.authenticationContext.getLoggedInUser();
    }

    @Override
    public int getAction() {
        return this.actionId;
    }

    @Override
    public void setAction(int action) {
        this.actionId = action;
    }

    @Override
    public ActionDescriptor getActionDescriptor() {
        if (this.actionDescriptor == null) {
            try {
                this.actionDescriptor = this.workflowManager.getWorkflow(this.getIssue()).getDescriptor().getAction(this.actionId);
            }
            catch (WorkflowException e) {
                throw new IllegalArgumentException("Cannot find workflow transition with id '" + this.actionId + "'.");
            }
        }
        if (this.actionDescriptor == null) {
            throw new IllegalArgumentException("No workflow action with id '" + this.actionId + "' available for issue " + this.getIssue().getKey());
        }
        return this.actionDescriptor;
    }

    @Override
    public void addErrorMessage(String error) {
        this.errorCollection.addErrorMessage(error);
    }

    @Override
    public void addError(String name, String error) {
        this.errorCollection.addError(name, error);
    }

    @Override
    public Map getAdditionalInputs() {
        HashMap<String, String> map = new HashMap<String, String>(this.additionalInputs.size() + 3);
        map.putAll(this.additionalInputs);
        if (this.fieldUpdated("comment")) {
            map.put("comment", this.getComment());
            map.put("commentLevel", this.getCommentLevel());
            map.put("roleLevel", this.getCommentRoleLevel());
        }
        map.put("username", this.getUsername());
        return map;
    }

    @Override
    public void addAdditionalInput(Object key, Object value) {
        this.additionalInputs.put(key, value);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public ErrorCollection validate() {
        this.validateComment();
        if (this.errorCollection.hasAnyErrors()) {
            return this.errorCollection;
        }
        for (FieldScreenRenderTab fieldScreenRenderTab : this.getFieldScreenRenderer().getFieldScreenRenderTabs()) {
            for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                if (!fieldScreenRenderLayoutItem.isShow(this.getIssue())) continue;
                OrderableField orderableField = fieldScreenRenderLayoutItem.getOrderableField();
                if ("resolution".equals(orderableField.getId())) {
                    fieldScreenRenderLayoutItem = new FieldScreenRenderLayoutItemImpl(fieldScreenRenderLayoutItem.getFieldScreenLayoutItem(), fieldScreenRenderLayoutItem.getFieldLayoutItem()){

                        @Override
                        public boolean isRequired() {
                            return true;
                        }
                    };
                }
                orderableField.validateParams(this.getOperationContext(), this.errorCollection, this.authenticationContext.getI18nHelper(), this.getIssue(), fieldScreenRenderLayoutItem);
            }
        }
        return this.errorCollection;
    }

    @Override
    public FieldScreenRenderer getFieldScreenRenderer() {
        if (this.fieldScreenRenderer == null) {
            this.fieldScreenRenderer = this.fieldScreenRendererFactory.getFieldScreenRenderer(this.getRemoteUser(), this.getIssue(), this.getActionDescriptor());
        }
        return this.fieldScreenRenderer;
    }

    private void validateComment() {
        if (this.fieldUpdated("comment")) {
            if (this.permissionManager.hasPermission(15, this.getProject(), this.getRemoteUser())) {
                this.commentService.isValidCommentData(this.getRemoteUser(), this.getIssue(), this.getCommentLevel(), this.getCommentRoleLevel(), this.errorCollection);
                if (!this.fieldUpdated("commentLevel") && !this.fieldUpdated("roleLevel")) {
                    this.setCommentLevel(null);
                }
            } else {
                this.errorCollection.addErrorMessage(this.authenticationContext.getI18nHelper().getText("admin.errors.user.does.not.have.permission", this.getRemoteUser() != null ? this.authenticationContext.getI18nHelper().getText("admin.errors.user", "'" + this.getRemoteUser().getName() + "'") : this.authenticationContext.getI18nHelper().getText("admin.errors.anonymous.user")));
            }
        }
    }

    private void setCommentLevel(String commentLevel) {
        this.params.put("commentLevel", commentLevel);
    }

    @Override
    public ErrorCollection progress() {
        if (this.hasScreen()) {
            for (FieldScreenRenderTab fieldScreenRenderTab : this.getFieldScreenRenderer().getFieldScreenRenderTabs()) {
                for (FieldScreenRenderLayoutItem fieldScreenRenderLayoutItem : fieldScreenRenderTab.getFieldScreenRenderLayoutItemsForProcessing()) {
                    if (!fieldScreenRenderLayoutItem.isShow(this.getIssue())) continue;
                    fieldScreenRenderLayoutItem.getOrderableField().updateIssue(fieldScreenRenderLayoutItem.getFieldLayoutItem(), this.getIssue(), this.params);
                }
            }
        }
        this.workflowManager.doWorkflowAction(this);
        return this.errorCollection;
    }

    @Override
    public void setParams(Map params) {
        this.params = params;
    }

    @Override
    public boolean hasScreen() {
        return StringUtils.isNotBlank((String)this.getActionDescriptor().getView());
    }

    private boolean fieldUpdated(String fieldId) {
        return this.params.containsKey(fieldId);
    }

    private OperationContext getOperationContext() {
        return new OperationContextImpl(new WorkflowIssueOperationImpl(this.getActionDescriptor()), this.params);
    }
}

