/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.workflow.ImmutableWorkflowDescriptor;
import com.atlassian.jira.workflow.JiraWorkflowDTO;
import com.atlassian.jira.workflow.JiraWorkflowDTOImpl;
import com.atlassian.jira.workflow.WorkflowDescriptorStore;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;

public class OfBizWorkflowDescriptorStore
implements WorkflowDescriptorStore {
    private static final Logger log = Logger.getLogger(OfBizWorkflowDescriptorStore.class);
    public static final String WORKFLOW_ENTITY_NAME = "Workflow";
    public static final String NAME_ENTITY_FIELD = "name";
    public static final String DESCRIPTOR_ENTITY_FIELD = "descriptor";
    private final OfBizDelegator ofBizDelegator;
    private static final String ID_ENTITY_FIELD = "id";

    public OfBizWorkflowDescriptorStore(OfBizDelegator ofBizDelegator) {
        this.ofBizDelegator = ofBizDelegator;
    }

    @Override
    public ImmutableWorkflowDescriptor getWorkflow(String name) throws FactoryException {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Workflow name cannot be null!");
        }
        GenericValue workflowGV = this.getWorkflowDescriptorGV(name);
        if (workflowGV != null) {
            return new ImmutableWorkflowDescriptor(this.convertGVToDescriptor(workflowGV));
        }
        return null;
    }

    @Override
    public boolean removeWorkflow(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Workflow name cannot be null!");
        }
        return this.ofBizDelegator.removeByAnd(WORKFLOW_ENTITY_NAME, EasyMap.build((Object)NAME_ENTITY_FIELD, (Object)name)) > 0;
    }

    @Override
    public boolean saveWorkflow(String name, WorkflowDescriptor workflowDescriptor, boolean replace) throws DataAccessException {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("Workflow name cannot be null!");
        }
        if (workflowDescriptor == null) {
            throw new IllegalArgumentException("Workflow descriptor cannot be null!");
        }
        GenericValue workflowGV = this.getWorkflowDescriptorGV(name);
        if (workflowGV != null && !replace) {
            return false;
        }
        if (workflowGV == null) {
            Map params = EasyMap.build((Object)NAME_ENTITY_FIELD, (Object)name, (Object)DESCRIPTOR_ENTITY_FIELD, (Object)this.convertDescriptorToXML(workflowDescriptor));
            this.ofBizDelegator.createValue(WORKFLOW_ENTITY_NAME, params);
        } else {
            workflowGV.setString(DESCRIPTOR_ENTITY_FIELD, this.convertDescriptorToXML(workflowDescriptor));
            this.ofBizDelegator.store(workflowGV);
        }
        return true;
    }

    @Override
    public String[] getWorkflowNames() {
        List<GenericValue> workflowGVs = this.ofBizDelegator.findAll(WORKFLOW_ENTITY_NAME);
        if (workflowGVs == null || workflowGVs.size() == 0) {
            return new String[0];
        }
        String[] ret = new String[workflowGVs.size()];
        int i = 0;
        for (GenericValue workflowGV : workflowGVs) {
            ret[i++] = workflowGV.getString(NAME_ENTITY_FIELD);
        }
        return ret;
    }

    @Override
    public List<JiraWorkflowDTO> getAllJiraWorkflowDTOs() {
        List<GenericValue> workflowGVs = this.ofBizDelegator.findAll(WORKFLOW_ENTITY_NAME);
        if (workflowGVs == null || workflowGVs.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<JiraWorkflowDTO> ret = new ArrayList<JiraWorkflowDTO>();
        for (GenericValue workflowGV : workflowGVs) {
            try {
                ret.add(new JiraWorkflowDTOImpl(workflowGV.getLong(ID_ENTITY_FIELD), workflowGV.getString(NAME_ENTITY_FIELD), this.convertGVToDescriptor(workflowGV)));
            }
            catch (FactoryException e) {
                log.error((Object)("Could not create a workflow descriptor for workflow with name '" + workflowGV.getString(NAME_ENTITY_FIELD) + "' and descriptor '" + workflowGV.getString(DESCRIPTOR_ENTITY_FIELD) + "'"), (Throwable)e);
            }
        }
        return ret;
    }

    private GenericValue getWorkflowDescriptorGV(String name) {
        List<GenericValue> workflowGVs = this.ofBizDelegator.findByAnd(WORKFLOW_ENTITY_NAME, EasyMap.build((Object)NAME_ENTITY_FIELD, (Object)name));
        if (workflowGVs.size() == 0) {
            return null;
        }
        if (workflowGVs.size() > 1) {
            throw new IllegalStateException("There are more than one workflows associated with '" + name + "' in the database!");
        }
        return workflowGVs.get(0);
    }

    String convertDescriptorToXML(WorkflowDescriptor descriptor) {
        return WorkflowUtil.convertDescriptorToXML(descriptor);
    }

    WorkflowDescriptor convertGVToDescriptor(GenericValue gv) throws FactoryException {
        WorkflowDescriptor descriptor = WorkflowUtil.convertXMLtoWorkflowDescriptor(gv.getString(DESCRIPTOR_ENTITY_FIELD));
        descriptor.setEntityId(gv.getLong(ID_ENTITY_FIELD).intValue());
        return descriptor;
    }
}

