/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.workflow.AbstractJiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.function.event.FireIssueEventFunction;
import com.atlassian.jira.workflow.function.issue.IssueCreateFunction;
import com.atlassian.jira.workflow.function.issue.IssueReindexFunction;
import com.atlassian.jira.workflow.validator.PermissionValidator;
import com.opensymphony.workflow.loader.AbstractDescriptor;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.DescriptorFactory;
import com.opensymphony.workflow.loader.ResultDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;

public class ConfigurableJiraWorkflow
extends AbstractJiraWorkflow {
    String name;

    public ConfigurableJiraWorkflow(String name, WorkflowDescriptor workflowDescriptor, WorkflowManager workflowManager) {
        super(workflowManager, workflowDescriptor);
        this.name = name;
    }

    public ConfigurableJiraWorkflow(String name, WorkflowManager workflowManager) {
        super(workflowManager, new WorkflowDescriptor());
        this.name = name;
        StepDescriptor step = DescriptorFactory.getFactory().createStepDescriptor();
        step.setId(1);
        step.setName("Open");
        step.getMetaAttributes().put("jira.status.id", "1");
        step.setParent((AbstractDescriptor)this.descriptor);
        this.descriptor.addStep(step);
        ActionDescriptor initialAction = DescriptorFactory.getFactory().createActionDescriptor();
        initialAction.setId(1);
        initialAction.setName("Create");
        initialAction.setParent((AbstractDescriptor)this.descriptor);
        this.descriptor.addInitialAction(initialAction);
        initialAction.getValidators().add(PermissionValidator.makeDescriptor("Create Issue"));
        ResultDescriptor resultDescriptor = DescriptorFactory.getFactory().createResultDescriptor();
        resultDescriptor.setStep(1);
        resultDescriptor.setStatus("open");
        initialAction.setUnconditionalResult(resultDescriptor);
        resultDescriptor.getPostFunctions().add(IssueCreateFunction.makeDescriptor());
        resultDescriptor.getPostFunctions().add(IssueReindexFunction.makeDescriptor());
        resultDescriptor.getPostFunctions().add(FireIssueEventFunction.makeDescriptor(EventType.ISSUE_CREATED_ID));
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isDraftWorkflow() {
        return false;
    }

    public void setDescription(String description) {
        this.descriptor.getMetaAttributes().put("jira.description", description);
    }

    public void setDescriptor(WorkflowDescriptor descriptor) {
        this.descriptor = descriptor;
    }
}

