/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.workflow;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.workflow.DraftWorkflowStore;
import com.atlassian.jira.workflow.JiraDraftWorkflow;
import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowUtil;
import com.opensymphony.workflow.FactoryException;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.StringUtils;

public class CachingDraftWorkflowStore
implements DraftWorkflowStore,
Startable {
    private final DraftWorkflowStore delegate;
    private final EventPublisher eventPublisher;
    private WorkflowManager workflowManager;
    private final ConcurrentMap<String, String> draftWorkflowCache = new ConcurrentHashMap<String, String>();
    private final ReadWriteLock cacheLock = new ReentrantReadWriteLock();
    private static final String NO_DRAFT = "NO_DRAFT";

    public CachingDraftWorkflowStore(DraftWorkflowStore delegate, EventPublisher eventPublisher) {
        this.delegate = delegate;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        try {
            this.cacheLock.writeLock().lock();
            this.draftWorkflowCache.clear();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JiraWorkflow getDraftWorkflow(String parentWorkflowName) throws DataAccessException {
        String workflowDescriptorXML;
        if (StringUtils.isEmpty((String)parentWorkflowName)) {
            throw new IllegalArgumentException("Can not get a draft workflow for a parent workflow name of null.");
        }
        this.cacheLock.readLock().lock();
        try {
            workflowDescriptorXML = (String)this.draftWorkflowCache.get(parentWorkflowName);
            if (workflowDescriptorXML == null || workflowDescriptorXML.equals(NO_DRAFT)) {
                JiraWorkflow draftWorkflow = this.delegate.getDraftWorkflow(parentWorkflowName);
                if (draftWorkflow == null) {
                    this.draftWorkflowCache.put(parentWorkflowName, NO_DRAFT);
                    workflowDescriptorXML = NO_DRAFT;
                } else {
                    this.draftWorkflowCache.put(parentWorkflowName, this.convertDescriptorToXML(draftWorkflow.getDescriptor()));
                    workflowDescriptorXML = (String)this.draftWorkflowCache.get(parentWorkflowName);
                }
            }
        }
        finally {
            this.cacheLock.readLock().unlock();
        }
        if (workflowDescriptorXML.equals(NO_DRAFT)) {
            return null;
        }
        return this.getJiraDraftWorkflow(parentWorkflowName, workflowDescriptorXML);
    }

    @Override
    public JiraWorkflow createDraftWorkflow(String authorName, JiraWorkflow parentWorkflow) throws DataAccessException, IllegalStateException, IllegalArgumentException {
        JiraWorkflow draftWorkflow = this.delegate.createDraftWorkflow(authorName, parentWorkflow);
        this.draftWorkflowCache.put(parentWorkflow.getName(), this.convertDescriptorToXML(draftWorkflow.getDescriptor()));
        return draftWorkflow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteDraftWorkflow(String parentWorkflowName) throws DataAccessException, IllegalArgumentException {
        boolean deleted;
        this.cacheLock.writeLock().lock();
        try {
            deleted = this.delegate.deleteDraftWorkflow(parentWorkflowName);
            if (deleted) {
                this.draftWorkflowCache.put(parentWorkflowName, NO_DRAFT);
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
        return deleted;
    }

    @Override
    public JiraWorkflow updateDraftWorkflow(String username, String parentWorkflowName, JiraWorkflow workflow) throws DataAccessException {
        JiraWorkflow updatedWorkflow = this.delegate.updateDraftWorkflow(username, parentWorkflowName, workflow);
        this.draftWorkflowCache.put(parentWorkflowName, this.convertDescriptorToXML(updatedWorkflow.getDescriptor()));
        return updatedWorkflow;
    }

    @Override
    public JiraWorkflow updateDraftWorkflowWithoutAudit(String parentWorkflowName, JiraWorkflow workflow) throws DataAccessException {
        JiraWorkflow updatedWorkflow = this.delegate.updateDraftWorkflowWithoutAudit(parentWorkflowName, workflow);
        this.draftWorkflowCache.put(parentWorkflowName, this.convertDescriptorToXML(updatedWorkflow.getDescriptor()));
        return updatedWorkflow;
    }

    WorkflowManager getWorkflowManager() {
        if (this.workflowManager == null) {
            this.workflowManager = ComponentAccessor.getWorkflowManager();
        }
        return this.workflowManager;
    }

    WorkflowDescriptor convertXMLtoWorkflowDescriptor(String parentWorkflowXML) throws FactoryException {
        return WorkflowUtil.convertXMLtoWorkflowDescriptor(parentWorkflowXML);
    }

    String convertDescriptorToXML(WorkflowDescriptor descriptor) {
        return WorkflowUtil.convertDescriptorToXML(descriptor);
    }

    private JiraWorkflow getJiraDraftWorkflow(String name, String workflowDescriptorXML) {
        try {
            return new JiraDraftWorkflow(name, this.getWorkflowManager(), this.convertXMLtoWorkflowDescriptor(workflowDescriptorXML));
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
    }
}

