/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.customfields.OperationContextImpl;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.OrderableField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraVelocityUtils;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.bean.FieldVisibilityBean;
import com.atlassian.jira.web.bean.I18nBean;
import com.atlassian.jira.web.component.AbstractWebComponent;
import com.atlassian.jira.web.util.SubTaskQuickCreationConfig;
import com.atlassian.util.profiling.UtilTimerStack;
import com.atlassian.velocity.VelocityManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ofbiz.core.entity.GenericValue;
import webwork.action.Action;
import webwork.action.ActionContext;

public class SubTaskQuickCreationWebComponent
extends AbstractWebComponent {
    private static final Logger log = Logger.getLogger(SubTaskQuickCreationWebComponent.class);
    private final Issue parentIssue;
    private final Action action;
    private final FieldManager fieldManager;
    private final JiraAuthenticationContext authenticationContext;
    private final SubTaskQuickCreationConfig config;
    private final MutableIssue subTask;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final List<String> subTaskIssueTypeIds;
    private final I18nBean i18nBean;
    private final OperationContextImpl operationContext;

    public SubTaskQuickCreationWebComponent(Issue parentIssue, Action action, IssueFactory issueFactory, SubTaskManager subTaskManager, FieldManager fieldManager, VelocityManager velocityManager, JiraAuthenticationContext authenticationContext, ApplicationProperties applicationProperties, SubTaskQuickCreationConfig config) {
        super(velocityManager, applicationProperties);
        this.i18nBean = new I18nBean(authenticationContext.getLoggedInUser());
        this.parentIssue = parentIssue;
        this.action = action;
        this.fieldManager = fieldManager;
        this.authenticationContext = authenticationContext;
        this.config = config;
        this.fieldVisibilityManager = new FieldVisibilityBean();
        this.operationContext = new OperationContextImpl(IssueOperations.CREATE_ISSUE_OPERATION, new HashMap());
        this.subTask = issueFactory.getIssue((GenericValue)null);
        this.subTask.setProject(this.parentIssue.getProject());
        this.subTask.setParentId(this.parentIssue.getId());
        if (subTaskManager.getSubTaskIssueTypeObjects().size() > 0) {
            for (IssueType issueType : subTaskManager.getSubTaskIssueTypeObjects()) {
                this.subTask.setIssueTypeObject(issueType);
            }
        }
        this.subTaskIssueTypeIds = new ArrayList<String>();
        for (IssueType subTaskIssueType : subTaskManager.getSubTaskIssueTypeObjects()) {
            this.subTaskIssueTypeIds.add(subTaskIssueType.getId());
        }
        this.setHistoryIssueType();
    }

    public Issue getParentIssue() {
        return this.parentIssue;
    }

    public Issue getSubTask() {
        return this.subTask;
    }

    public String getSubTaskFieldHtml(String fieldId, boolean showHeaders) {
        if (!this.fieldVisibilityManager.isFieldHiddenInAllSchemes(this.subTask.getProjectObject().getId(), fieldId, this.subTaskIssueTypeIds)) {
            OrderableField field = this.fieldManager.getOrderableField(fieldId);
            if (field != null) {
                if (this.isFieldInScope(field)) {
                    if (field.isShown(this.subTask)) {
                        String i18nKey;
                        StringBuffer sb = new StringBuffer();
                        if (!showHeaders && (i18nKey = this.config.getFieldI18nLabelKey(field.getId())) != null) {
                            sb.append("<td id=\"label_").append(fieldId).append("\" class=\"minNoWrap\" style=\"text-align:right;\">");
                            sb.append(this.i18nBean.getText(i18nKey));
                            sb.append(":</td>");
                        }
                        FieldLayoutItem layoutItem = this.getLayoutItem(field);
                        Map displayParameters = EasyMap.build((Object)"noHeader", (Object)(!showHeaders ? 1 : 0));
                        sb.append(field.getCreateHtml(layoutItem, this.operationContext, this.action, this.subTask, displayParameters));
                        return sb.toString();
                    }
                    log.debug((Object)("The user does not have permissions to edit field with id '" + fieldId + "'."));
                    return "<td>&nbsp</td>";
                }
            } else {
                log.error((Object)("Cannot find field with id '" + fieldId + "'."));
            }
        }
        return showHeaders ? "" : "<td>&nbsp;</td>";
    }

    public String getSubTaskFieldPreset(String fieldId) {
        return this.config.getPreset(fieldId);
    }

    protected boolean isFieldInScope(OrderableField field) {
        if (field != null) {
            if (this.fieldManager.isCustomField(field)) {
                CustomField customField = this.fieldManager.getCustomField(field.getId());
                if (customField.isInScope(this.subTask.getProjectObject(), Collections.<String>emptyList())) {
                    return true;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Custom field with id '" + field.getId() + "' is not in scope for project '" + this.subTask.getProjectObject().getName() + "'."));
                }
                return false;
            }
            return true;
        }
        return false;
    }

    protected void setHistoryIssueType() {
        String issueTypeId = (String)ActionContext.getSession().get("jira.user.history.subtask.issuetype");
        if (issueTypeId != null) {
            this.operationContext.getFieldValuesHolder().put("issuetype", issueTypeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getHtml() {
        try {
            UtilTimerStack.push((String)this.getClass().getName());
            I18nHelper i18n = this.authenticationContext.getI18nHelper();
            HashMap<String, Object> startingParams = MapBuilder.newBuilder("i18n", i18n).add("webComponent", (I18nHelper)((Object)this)).add("displayFieldIds", (I18nHelper)((Object)this.getDisplayFieldIds())).add("presetFieldIds", (I18nHelper)((Object)this.getPresetFieldIds())).toHashMap();
            Map<String, Object> params = JiraVelocityUtils.getDefaultVelocityParams(startingParams, this.authenticationContext);
            String string = this.getHtml(this.config.getVelocityTemplate(), params);
            return string;
        }
        finally {
            UtilTimerStack.pop((String)this.getClass().getName());
        }
    }

    protected Collection getDisplayFieldIds() {
        return this.config.getDisplayFieldIds();
    }

    protected Collection getPresetFieldIds() {
        return this.config.getPresetFieldIds();
    }

    private FieldLayoutItem getLayoutItem(final OrderableField field) {
        return new FieldLayoutItem(){

            @Override
            public OrderableField getOrderableField() {
                return field;
            }

            @Override
            public String getFieldDescription() {
                return "";
            }

            @Override
            public boolean isHidden() {
                return false;
            }

            @Override
            public boolean isRequired() {
                return false;
            }

            @Override
            public String getRendererType() {
                return "jira-text-renderer";
            }

            @Override
            public FieldLayout getFieldLayout() {
                return null;
            }

            @Override
            public int compareTo(FieldLayoutItem o) {
                return 0;
            }
        };
    }
}

