/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.web.util.FieldParser;
import com.atlassian.jira.web.util.SubTaskQuickCreationConfig;
import com.google.common.collect.ImmutableList;
import com.opensymphony.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SubTaskQuickCreationConfigImpl
implements SubTaskQuickCreationConfig {
    private static final Logger log = Logger.getLogger(SubTaskQuickCreationConfigImpl.class);
    private static final Collection<String> DEFAULT_LIST = ImmutableList.of((Object)"summary", (Object)"issuetype", (Object)"assignee", (Object)"timetracking");
    private final ApplicationProperties applicationProperties;
    private final FieldManager fieldManager;

    public SubTaskQuickCreationConfigImpl(ApplicationProperties applicationProperties, FieldManager fieldManager) {
        this.applicationProperties = applicationProperties;
        this.fieldManager = fieldManager;
    }

    @Override
    public Collection getDisplayFieldIds() {
        return this.parseFieldIds(new FieldParser(){

            @Override
            public Object parse(String fieldId) {
                if (TextUtils.stringSet((String)fieldId)) {
                    String[] fieldVal = StringUtils.split((String)fieldId, (char)'=');
                    if (fieldVal.length != 1) {
                        return null;
                    }
                    String fieldValue = fieldVal[0].trim();
                    if (SubTaskQuickCreationConfigImpl.this.fieldManager.getOrderableField(fieldValue) != null) {
                        return fieldValue;
                    }
                    log.error((Object)("Orderable field with id '" + fieldId + "' does not exist."));
                }
                return null;
            }
        });
    }

    @Override
    public Collection getFieldIds() {
        return this.parseFieldIds(new FieldParser(){

            @Override
            public Object parse(String fieldId) {
                String[] fieldVal = StringUtils.split((String)fieldId, (char)'=');
                if (fieldVal.length > 0 && SubTaskQuickCreationConfigImpl.this.fieldManager.getOrderableField(fieldVal[0].trim()) != null) {
                    return fieldVal[0].trim();
                }
                return null;
            }
        });
    }

    @Override
    public Collection getPresetFieldIds() {
        return this.parseFieldIds(new FieldParser(){

            @Override
            public Object parse(String fieldId) {
                String[] fieldVal = StringUtils.split((String)fieldId, (char)'=');
                if (fieldVal.length != 2) {
                    return null;
                }
                if (SubTaskQuickCreationConfigImpl.this.fieldManager.getOrderableField(fieldVal[0].trim()) != null) {
                    return fieldVal[0].trim();
                }
                log.error((Object)("Orderable field with id '" + fieldId + "' does not exist."));
                return null;
            }
        });
    }

    @Override
    public String getFieldI18nLabelKey(String fieldId) {
        return this.parseFieldLabelKey(fieldId);
    }

    @Override
    public String getPreset(String fieldId) {
        Collection presets = this.parseFieldIds(new FieldParser(){

            @Override
            public Object parse(String fieldId) {
                String[] fieldVal;
                if (TextUtils.stringSet((String)fieldId) && (fieldVal = StringUtils.split((String)fieldId, (char)'=')).length == 2) {
                    fieldVal[0] = fieldVal[0].trim();
                    fieldVal[1] = fieldVal[1].trim();
                    return fieldVal;
                }
                return null;
            }
        });
        for (String[] val : presets) {
            if (!val[0].equals(fieldId)) continue;
            return val[1];
        }
        return null;
    }

    @Override
    public String getVelocityTemplate() {
        return this.applicationProperties.getDefaultBackedString("jira.subtask.quickcreateform.template");
    }

    private Collection parseFieldIds(FieldParser fieldParser) {
        String fieldIdsProperty = this.applicationProperties.getDefaultBackedString("jira.subtask.quickcreateform.fields");
        if (TextUtils.stringSet((String)fieldIdsProperty)) {
            String[] fieldIdLabels = StringUtils.splitPreserveAllTokens((String)fieldIdsProperty, (String)",");
            if (fieldIdLabels != null) {
                ArrayList<Object> ids = new ArrayList<Object>();
                for (int i = 0; i < fieldIdLabels.length; ++i) {
                    String fieldIdLabel = fieldIdLabels[i];
                    String[] fieldEntities = StringUtils.splitPreserveAllTokens((String)fieldIdLabel, (String)":");
                    String fieldId = fieldEntities.length == 0 ? "" : fieldEntities[0];
                    Object parsed = fieldParser.parse(fieldId);
                    if (parsed == null) continue;
                    ids.add(parsed);
                }
                return ids;
            }
            log.error((Object)("The value '" + fieldIdsProperty + "' for property '" + "jira.subtask.quickcreateform.fields" + "' is invalid . Using default."));
            return DEFAULT_LIST;
        }
        log.error((Object)"Could not find entry for 'jira.subtask.quickcreateform.fields' in . Using default.");
        return DEFAULT_LIST;
    }

    private String parseFieldLabelKey(String fieldId) {
        String[] fieldIdLabels;
        String fieldIdsProperty = this.applicationProperties.getDefaultBackedString("jira.subtask.quickcreateform.fields");
        if (TextUtils.stringSet((String)fieldIdsProperty) && (fieldIdLabels = StringUtils.splitPreserveAllTokens((String)fieldIdsProperty, (String)",")) != null) {
            for (int i = 0; i < fieldIdLabels.length; ++i) {
                String fieldIdLabel = fieldIdLabels[i];
                String[] fieldEntries = StringUtils.splitPreserveAllTokens((String)fieldIdLabel, (String)":");
                if (fieldEntries.length <= 0 || !fieldEntries[0].equals(fieldId)) continue;
                return fieldEntries.length > 1 ? fieldEntries[1] : null;
            }
        }
        return null;
    }
}

