/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.jira.web.util.OutlookDateManager;
import com.atlassian.util.concurrent.CopyOnWriteMap;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;

public class OutlookDateManagerImpl
implements OutlookDateManager,
Startable {
    private final ConcurrentMap<Locale, OutlookDate> outlookDates = CopyOnWriteMap.newHashMap();
    private final EventPublisher eventPublisher;
    private final ApplicationProperties applicationProperties;
    private final I18nHelper.BeanFactory i18nHelperFactory;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public OutlookDateManagerImpl(EventPublisher eventPublisher) {
        this(eventPublisher, ComponentAccessor.getApplicationProperties(), null, ComponentAccessor.getComponentOfType(DateTimeFormatterFactory.class));
    }

    public OutlookDateManagerImpl(EventPublisher eventPublisher, ApplicationProperties applicationProperties, I18nHelper.BeanFactory i18nHelperFactory, DateTimeFormatterFactory dateTimeFormatterFactory) {
        this.eventPublisher = eventPublisher;
        this.applicationProperties = applicationProperties;
        this.i18nHelperFactory = i18nHelperFactory;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    @Override
    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent event) {
        this.refresh();
    }

    @Override
    public void refresh() {
        this.outlookDates.clear();
    }

    @Override
    public OutlookDate getOutlookDate(Locale locale) {
        OutlookDate result = (OutlookDate)this.outlookDates.get(locale);
        while (result == null) {
            this.outlookDates.putIfAbsent(locale, new OutlookDate(locale, this.applicationProperties, this.i18nHelperFactory, this.dateTimeFormatterFactory));
            result = (OutlookDate)this.outlookDates.get(locale);
        }
        return result;
    }
}

