/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.util;

import com.opensymphony.util.TextUtils;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class ChangeHistoryUtils {
    private static final Logger LOG = Logger.getLogger(ChangeHistoryUtils.class);
    public static final String CHANGED_FROM = "] changed from [";
    public static final String TO = "] to [";
    public static final String SET_TO = "] set to [";
    public static final String WAS_ADDED = "] was added";
    public static final String WAS_REMOVED = "] was removed";
    public static final String LINE_ENDING = "]";
    public static final String TERMINATOR = "\n";
    public static final String TERMINATOR_BR = "<br>\n";

    public static String highlight(String body, String colour) {
        String htmlBody = TextUtils.plainTextToHtml((String)body);
        StringTokenizer st = new StringTokenizer(htmlBody, TERMINATOR);
        StringBuffer buff = new StringBuffer(htmlBody.length());
        while (st.hasMoreTokens()) {
            buff.append(ChangeHistoryUtils.highlightLine(st.nextToken() + TERMINATOR, colour));
        }
        return TextUtils.closeTags((String)buff.toString());
    }

    public static String highlightLine(String line, String colour) {
        int firstCloseBracket;
        boolean terminatorBr = false;
        if (line.endsWith(TERMINATOR_BR)) {
            line = line.substring(0, line.length() - 5);
            terminatorBr = true;
        } else {
            line = line.substring(0, line.length() - 1);
        }
        if (line.length() > 0 && line.charAt(0) == '[' && (firstCloseBracket = line.indexOf(93)) > 0 && firstCloseBracket < 15 && line.charAt(firstCloseBracket + 1) == ' ') {
            line = "[<font color=" + colour + ">" + line.substring(1, firstCloseBracket) + "</font>" + line.substring(firstCloseBracket);
        }
        int changedFrom = line.indexOf(CHANGED_FROM);
        int to = line.indexOf(TO);
        if (changedFrom > 0 || to > 0) {
            if (changedFrom > 0) {
                line = line.substring(0, changedFrom) + CHANGED_FROM + "<font color=" + colour + ">" + line.substring(changedFrom + CHANGED_FROM.length());
                to = line.indexOf(TO);
            }
            if (to > 0) {
                line = line.substring(0, to) + "</font>" + TO + "<font color=" + colour + ">" + line.substring(to + TO.length());
            }
        } else {
            int secondBracket;
            int setTo = line.indexOf(SET_TO);
            if (setTo > 0) {
                line = line.substring(0, setTo) + SET_TO + "<font color=" + colour + ">" + line.substring(setTo + SET_TO.length());
            } else if (line.endsWith(WAS_ADDED)) {
                int secondBracket2 = line.indexOf(91, line.indexOf(91) + 1);
                if (secondBracket2 > 0) {
                    line = line.substring(0, secondBracket2 + 1) + "<font color=" + colour + ">" + line.substring(secondBracket2 + 1, line.lastIndexOf(WAS_ADDED)) + "</font>" + WAS_ADDED;
                }
            } else if (line.endsWith(WAS_REMOVED) && (secondBracket = line.indexOf(91, line.indexOf(91) + 1)) > 0) {
                line = line.substring(0, secondBracket + 1) + "<font color=" + colour + ">" + line.substring(secondBracket + 1, line.lastIndexOf(WAS_REMOVED)) + "</font>" + WAS_REMOVED;
            }
        }
        if (line.endsWith(LINE_ENDING)) {
            line = line.substring(0, line.length() - LINE_ENDING.length()) + "</font>" + LINE_ENDING;
        }
        line = terminatorBr ? line + TERMINATOR_BR : line + TERMINATOR;
        return line;
    }
}

