/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.session.currentusers;

import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.util.http.HttpRequestType;
import com.atlassian.jira.web.session.currentusers.JiraUserSession;
import com.atlassian.jira.web.session.currentusers.JiraUserSessionTrackerDeletionStrategy;
import com.atlassian.jira.web.session.currentusers.MutableJiraUserSession;
import com.atlassian.jira.web.session.currentusers.SnapshotJiraUserUserSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class JiraUserSessionTracker {
    private final ConcurrentMap<String, MutableJiraUserSession> sessionMap = new ConcurrentHashMap<String, MutableJiraUserSession>();
    private final JiraUserSessionTrackerDeletionStrategy deletionStrategy = new JiraUserSessionTrackerDeletionStrategy();
    public static final Comparator<JiraUserSession> BY_LAST_ACCESS_TIME = new Comparator<JiraUserSession>(){

        @Override
        public int compare(JiraUserSession o1, JiraUserSession o2) {
            Date lat1 = o1.getLastAccessTime();
            Date lat2 = o2.getLastAccessTime();
            if (lat1 == null && lat2 == null) {
                return 0;
            }
            if (lat1 == null) {
                return 1;
            }
            if (lat2 == null) {
                return -1;
            }
            return lat1.compareTo(lat2);
        }
    };

    public static JiraUserSessionTracker getInstance() {
        return ComponentManager.getComponentInstanceOfType(JiraUserSessionTracker.class);
    }

    public static void recordInteraction(HttpServletRequest httpServletRequest) {
        JiraUserSessionTracker tracker = JiraUserSessionTracker.getInstance();
        if (tracker != null) {
            tracker.recordInteractionImpl(httpServletRequest);
        }
    }

    void removeSession(String sessionId) {
        this.sessionMap.remove(sessionId);
    }

    void recordInteractionImpl(HttpServletRequest httpServletRequest) {
        String soapSessionId = (String)httpServletRequest.getAttribute("jira.rpc.soap.soap.sessionid");
        if (soapSessionId != null) {
            String userName = (String)httpServletRequest.getAttribute("jira.rpc.soap.username");
            this.recordSoapInteraction(httpServletRequest, soapSessionId, soapSessionId, userName);
        } else {
            String asessionId = (String)httpServletRequest.getAttribute("jira.request.assession.id");
            this.recordHttpInteraction(httpServletRequest, asessionId);
        }
    }

    private void recordHttpInteraction(HttpServletRequest httpServletRequest, final String asessionId) {
        HttpSession httpSession = httpServletRequest.getSession(false);
        if (httpSession != null) {
            final String httpSessionId = httpSession.getId();
            this.recordInteractionImpl(httpSessionId, httpServletRequest, httpServletRequest.getRemoteUser(), new MutableSessionFactory(){

                @Override
                public MutableJiraUserSession createUserSession() {
                    return new MutableJiraUserSession(HttpRequestType.HTTP, httpSessionId, asessionId);
                }
            });
        }
    }

    private void recordSoapInteraction(HttpServletRequest httpServletRequest, String sessionId, final String asessionId, final String userName) {
        final String newSessionId = "S-" + sessionId;
        this.recordInteractionImpl(newSessionId, httpServletRequest, userName, new MutableSessionFactory(){

            @Override
            public MutableJiraUserSession createUserSession() {
                return new MutableJiraUserSession(HttpRequestType.SOAP, newSessionId, asessionId, userName);
            }
        });
    }

    private void recordInteractionImpl(String sessionId, HttpServletRequest httpServletRequest, String userName, MutableSessionFactory sessionFactory) {
        this.deletionStrategy.deleteStaleSessions(this.sessionMap);
        MutableJiraUserSession userSession = (MutableJiraUserSession)this.sessionMap.get(sessionId);
        if (userSession == null) {
            MutableJiraUserSession newSession = sessionFactory.createUserSession();
            MutableJiraUserSession previousValue = this.sessionMap.putIfAbsent(sessionId, newSession);
            userSession = previousValue != null ? previousValue : newSession;
        }
        userSession.recordInteraction(httpServletRequest, userName);
    }

    public List<JiraUserSession> getSnapshot() {
        ArrayList<JiraUserSession> userSessions = new ArrayList<JiraUserSession>();
        for (MutableJiraUserSession jiraUserSession : this.sessionMap.values()) {
            userSessions.add(new SnapshotJiraUserUserSession(jiraUserSession));
        }
        Collections.sort(userSessions, Collections.reverseOrder(BY_LAST_ACCESS_TIME));
        return userSessions;
    }

    private static interface MutableSessionFactory {
        public MutableJiraUserSession createUserSession();
    }
}

