/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.UserPropertyManager;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.servlet.AbstractAvatarServlet;
import com.opensymphony.module.propertyset.PropertySet;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class ViewUserAvatarServlet
extends AbstractAvatarServlet {
    @Override
    protected Long validateInput(String ownerId, Long avatarId, HttpServletResponse response) throws IOException {
        UserPropertyManager userPropertyManager = ComponentManager.getComponent(UserPropertyManager.class);
        if (StringUtils.isBlank((String)ownerId) && avatarId == null) {
            response.sendError(404, "No avatar requested");
            return null;
        }
        if (StringUtils.isNotBlank((String)ownerId)) {
            User user = this.getUserUtil().getUser(ownerId);
            if (user == null) {
                return Long.parseLong(this.getApplicationProperties().getString("jira.avatar.user.anonymous.id"));
            }
            if (!this.getAvatarManager().hasPermissionToView(this.getAuthenticationContext().getLoggedInUser(), Avatar.Type.USER, ownerId)) {
                avatarId = Long.parseLong(this.getApplicationProperties().getString("jira.avatar.user.default.id"));
            }
            if (avatarId == null) {
                PropertySet userPropertySet = userPropertyManager.getPropertySet(user);
                avatarId = userPropertySet.exists("user.avatar.id") ? Long.valueOf(userPropertySet.getLong("user.avatar.id")) : Long.valueOf(Long.parseLong(this.getApplicationProperties().getString("jira.avatar.user.default.id")));
            }
        }
        return avatarId;
    }

    @Override
    protected String getOwnerIdParamName() {
        return "ownerId";
    }

    JiraAuthenticationContext getAuthenticationContext() {
        return ComponentAccessor.getJiraAuthenticationContext();
    }

    ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    UserUtil getUserUtil() {
        return ComponentAccessor.getUserUtil();
    }
}

