/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.thumbnail.ThumbnailManager;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.web.servlet.HttpResponseHeaders;
import com.atlassian.jira.web.servlet.ViewAttachmentServlet;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewThumbnailServlet
extends ViewAttachmentServlet {
    @Override
    protected File getFileName(HttpServletRequest request, HttpServletResponse response) throws DataAccessException, PermissionException {
        Attachment attachment = this.getAttachment(this.attachmentPath(request));
        if (!this.hasPermissionToViewAttachment(this.getUserName(), attachment)) {
            throw new PermissionException("You do not have permissions to view this attachment");
        }
        return AttachmentUtils.getThumbnailFile(attachment);
    }

    @Override
    protected void setResponseHeaders(HttpServletRequest request, HttpServletResponse response) {
        Attachment attachment = this.getAttachment(this.attachmentPath(request));
        File thumbnailFile = AttachmentUtils.getThumbnailFile(attachment);
        response.setContentType(ThumbnailManager.MIME_TYPE.toString());
        response.setContentLength((int)thumbnailFile.length());
        response.setHeader("Content-Disposition", "inline; filename=" + thumbnailFile.getName() + ";");
        HttpResponseHeaders.cachePrivatelyForAboutOneYear(response);
    }
}

