/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.avatar.TemporaryAvatar;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.web.servlet.ViewProjectAvatarServlet;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ViewTemporaryAvatarServlet
extends ViewProjectAvatarServlet {
    private static final int BUFFER_SIZE = 8192;

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        TemporaryAvatar temporaryAvatar = (TemporaryAvatar)request.getSession().getAttribute("tempAvatarFile");
        if (temporaryAvatar == null || !temporaryAvatar.getFile().exists()) {
            response.sendError(404);
            return;
        }
        response.setHeader("Expires", "Fri, 01 Jan 1990 00:00:00 GMT");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-control", "no-cache, must-revalidate");
        response.setContentType(temporaryAvatar.getContentType());
        ServletOutputStream out = response.getOutputStream();
        boolean bytesWritten = false;
        try {
            IOUtil.copy((InputStream)new FileInputStream(temporaryAvatar.getFile()), (OutputStream)out, 8192);
            bytesWritten = true;
        }
        catch (IOException e) {
            ViewTemporaryAvatarServlet.handleOutputStreamingException(response, bytesWritten, e);
        }
    }
}

