/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.BrowserUtils;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.web.util.HostileAttachmentsHelper;
import com.atlassian.jira.web.util.Ie6MimeSniffer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class MimeSniffingKit {
    public static final String CONTENT_DISPOSITION_ATTACHMENT = "attachment";
    public static final String CONTENT_DISPOSITION_INLINE = "inline";
    private static final Logger log = Logger.getLogger(MimeSniffingKit.class);
    private final ApplicationProperties applicationProperties;
    private HostileAttachmentsHelper attachmentHelper;

    public MimeSniffingKit(ApplicationProperties applicationProperties) {
        this.applicationProperties = applicationProperties;
        this.attachmentHelper = new HostileAttachmentsHelper();
    }

    public String getContentDisposition(Attachment attachment, String userAgent) throws IOException {
        File attachmentFile = this.getFileForAttachment(attachment);
        return this.getContentDisposition(attachment.getFilename(), attachment.getMimetype(), userAgent, attachmentFile);
    }

    public String getContentDisposition(String fileName, String mimeContentType, String userAgent, File file) throws IOException {
        String mimeSniffingPolicy = this.getMimeSniffingPolicy();
        boolean forceDownload = false;
        if (log.isDebugEnabled() && mimeSniffingPolicy.equalsIgnoreCase("insecure")) {
            log.debug((Object)"Mime sniffing policy is insecure, attachment will always be displayed inline");
        }
        if (!mimeSniffingPolicy.equalsIgnoreCase("insecure") && this.isExecutableContent(fileName, mimeContentType)) {
            forceDownload = true;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Attachment \"" + fileName + "\" (" + mimeContentType + ")" + " presents as executable content, forcing download."));
            }
        } else if (mimeSniffingPolicy.equalsIgnoreCase("workaround") && BrowserUtils.isIe456Or7(userAgent)) {
            Ie6MimeSniffer sniffer = new Ie6MimeSniffer();
            byte[] fileBytes = this.getLeadingFileBytes(file, 256);
            forceDownload = sniffer.smellsLikeHtml(fileBytes);
            if (forceDownload) {
                log.debug((Object)"Detected Internet Explorer and file contents would be sniffed as HTML, forcing download");
            }
        } else if (mimeSniffingPolicy.equalsIgnoreCase("secure")) {
            forceDownload = true;
        }
        return forceDownload ? CONTENT_DISPOSITION_ATTACHMENT : CONTENT_DISPOSITION_INLINE;
    }

    File getFileForAttachment(Attachment attachment) {
        return AttachmentUtils.getAttachmentFile(attachment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getLeadingFileBytes(File attachmentFile, int numBytes) throws IOException {
        byte[] byArray;
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(attachmentFile);
            byArray = IOUtil.getLeadingBytes(stream, numBytes);
        }
        catch (Throwable throwable) {
            IOUtil.shutdownStream(stream);
            throw throwable;
        }
        IOUtil.shutdownStream(stream);
        return byArray;
    }

    boolean isExecutableContent(String name, String contentType) {
        return this.attachmentHelper.isExecutableFileExtension(name) || this.attachmentHelper.isExecutableContentType(contentType);
    }

    private String getMimeSniffingPolicy() {
        String mimeSniffingPolicy = this.applicationProperties.getDefaultBackedString("jira.attachment.download.mime.sniffing.workaround");
        if (mimeSniffingPolicy == null) {
            mimeSniffingPolicy = "workaround";
            log.warn((Object)"Missing MIME sniffing policy application property jira.attachment.download.mime.sniffing.workaround ! Defaulting to workaround");
        }
        if (!("insecure".equalsIgnoreCase(mimeSniffingPolicy) || "secure".equalsIgnoreCase(mimeSniffingPolicy) || "workaround".equalsIgnoreCase(mimeSniffingPolicy))) {
            log.warn((Object)("MIME sniffing policy application property is invalid: " + mimeSniffingPolicy + " ! Defaulting to " + "workaround"));
            mimeSniffingPolicy = "workaround";
        }
        return mimeSniffingPolicy;
    }
}

