/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.ComponentManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentZipFileCreator;
import com.atlassian.jira.issue.attachment.AttachmentZipKit;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.AttachmentUtils;
import com.atlassian.jira.util.IOUtil;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.http.JiraHttpUtils;
import com.atlassian.jira.util.mime.MimeManager;
import com.atlassian.jira.web.exception.WebExceptionChecker;
import com.atlassian.jira.web.servlet.MimeSniffingKit;
import com.atlassian.seraph.util.RedirectUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class AttachmentZipServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(AttachmentZipServlet.class);
    private static final String SECURE_VIEWS_SECURITYBREACH_JSP = "/secure/views/securitybreach.jsp";
    private static final String APPLICATION_OCTET_STREAM = "application/octet-stream";
    private static final String CONTENT_DISPOSITION_ATTACHMENT = "attachment";
    private static final Pattern ISSUE_ID_ONLY = Pattern.compile(".+/([0-9]+)\\.zip");
    private static final Pattern ISSUE_ID_AND_ZIP = Pattern.compile(".+/unzip/([0-9]+)/([0-9]+)(\\[|%5B)([0-9]+)(\\]|%5D)/.*");

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Issue issue;
        if (!this.checkSupportEnabled()) {
            httpServletResponse.sendError(404, "Attachments as ZIP support is disabled");
            return;
        }
        String uri = httpServletRequest.getRequestURI();
        try {
            issue = this.getIssue(uri);
        }
        catch (PermissionException e) {
            this.redirectForSecurityBreach(httpServletRequest, httpServletResponse);
            return;
        }
        if (issue == null) {
            httpServletResponse.sendError(404, "Could not find issue");
            return;
        }
        if (uri.contains("unzip")) {
            this.unzipSpecifiedAttachment(httpServletRequest, httpServletResponse, issue, uri);
        } else {
            this.zipAllAttachments(httpServletRequest, httpServletResponse, issue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void zipAllAttachments(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Issue issue) throws IOException, ServletException {
        block10: {
            File zipFile;
            String issueKey = issue.getKey();
            try {
                zipFile = this.createAttachmentsZipFile(issue);
            }
            catch (IOException e) {
                log.error((Object)("Can not create temporary zip file : " + httpServletRequest.getPathInfo() + ": " + e.getMessage()), (Throwable)e);
                httpServletResponse.sendError(404, "Could not create zip file for issue : " + issueKey);
                return;
            }
            try {
                this.setResponseHeaders(httpServletResponse, zipFile, issueKey);
                this.writeZipResponse(httpServletResponse, zipFile);
            }
            catch (Exception e) {
                if (WebExceptionChecker.canBeSafelyIgnored(e)) {
                    return;
                }
                if (!httpServletResponse.isCommitted()) {
                    httpServletResponse.sendError(404, "Could not serve zip file of attachments for issue " + issueKey + " : " + e.getMessage());
                    break block10;
                }
                throw new ServletException("Could not serve zip file of attachments for issue " + issueKey, (Throwable)e);
            }
            finally {
                this.deleteFile(zipFile);
            }
        }
    }

    private void unzipSpecifiedAttachment(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Issue issue, String uri) throws IOException {
        String issueKey = issue.getKey();
        Matcher matcher = ISSUE_ID_AND_ZIP.matcher(uri);
        if (!matcher.find() || matcher.groupCount() != 5) {
            httpServletResponse.sendError(404, "Could not create zip file for issue : " + issueKey);
            return;
        }
        long attachmentId = Long.parseLong(matcher.group(2));
        int entryIndex = Integer.parseInt(matcher.group(4));
        AttachmentZipKit zipKit = new AttachmentZipKit();
        File zipFile = this.getFileFor(issue, attachmentId);
        if (!zipKit.isZip(zipFile)) {
            httpServletResponse.sendError(404, "The attachment is not a zip file: " + issueKey + " : " + attachmentId);
            return;
        }
        this.streamSpecificZipEntry(httpServletRequest, httpServletResponse, entryIndex, zipKit, zipFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamSpecificZipEntry(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, int entryIndex, AttachmentZipKit zipKit, File zipFile) throws IOException {
        InputStream is = null;
        File tempFile = null;
        try {
            AttachmentZipKit.ZipEntryInputStream zipEntryInputStream = zipKit.extractFile(zipFile, entryIndex);
            tempFile = this.createTempFileFromZip(zipEntryInputStream);
            String entryFileName = new File(zipEntryInputStream.getZipEntry().getName()).getName();
            this.sniffContentAndSetZipEntryResponseHeaders(httpServletRequest, httpServletResponse, tempFile, entryFileName);
            FileInputStream inputStream = new FileInputStream(tempFile);
            IOUtil.copy((InputStream)inputStream, (OutputStream)httpServletResponse.getOutputStream());
        }
        finally {
            IOUtil.shutdownStream(is);
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createTempFileFromZip(AttachmentZipKit.ZipEntryInputStream zipEntryInputStream) throws IOException {
        File tempfile = File.createTempFile("jira", ".tmp");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(tempfile);
            IOUtil.copy((InputStream)zipEntryInputStream, (OutputStream)fileOutputStream);
        }
        catch (Throwable throwable) {
            IOUtil.shutdownStream(fileOutputStream);
            throw throwable;
        }
        IOUtil.shutdownStream(fileOutputStream);
        return tempfile;
    }

    private void sniffContentAndSetZipEntryResponseHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, File file, String entryFileName) throws IOException {
        MimeSniffingKit sniffingKit = ComponentManager.getComponent(MimeSniffingKit.class);
        MimeManager mimeManager = ComponentManager.getComponent(MimeManager.class);
        String userAgent = httpServletRequest.getHeader("USER-AGENT");
        String suggestedContentType = mimeManager.getSanitisedMimeType(APPLICATION_OCTET_STREAM, entryFileName);
        String suggestedContentDisposition = sniffingKit.getContentDisposition(file.getName(), suggestedContentType, userAgent, file);
        this.setFileDownloadHeaders(httpServletResponse, file, entryFileName, suggestedContentType, suggestedContentDisposition);
    }

    private File getFileFor(Issue issue, long attachmentId) {
        for (Attachment o : issue.getAttachments()) {
            Attachment attachment = o;
            if (!attachment.getId().equals(attachmentId)) continue;
            return AttachmentUtils.getAttachmentFile(attachment);
        }
        return null;
    }

    private void redirectForSecurityBreach(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.getLoggedInUser() != null) {
            RequestDispatcher rd = httpServletRequest.getRequestDispatcher(SECURE_VIEWS_SECURITYBREACH_JSP);
            JiraHttpUtils.setNoCacheHeaders(httpServletResponse);
            rd.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        } else {
            httpServletResponse.sendRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)httpServletRequest));
        }
    }

    private Issue getIssue(String url) throws PermissionException {
        Matcher matcher = ISSUE_ID_ONLY.matcher(url);
        String issueId = null;
        if (matcher.find()) {
            issueId = matcher.group(1);
        } else {
            matcher = ISSUE_ID_AND_ZIP.matcher(url);
            if (matcher.find() && matcher.groupCount() == 5) {
                issueId = matcher.group(1);
            }
        }
        return this.parseForIssue(issueId);
    }

    private Issue parseForIssue(String issueId) throws PermissionException {
        if (issueId == null) {
            return null;
        }
        try {
            Long id = Long.parseLong(issueId);
            MutableIssue issue = ComponentAccessor.getIssueManager().getIssueObject(id);
            if (issue != null && !this.hasPermissionToViewAttachment(issue)) {
                throw new PermissionException("The user does not have permission to see this issue");
            }
            return issue;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private File createAttachmentsZipFile(Issue issue) throws IOException {
        AttachmentZipFileCreator zipFileCreator = new AttachmentZipFileCreator(issue);
        return zipFileCreator.toZipFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeZipResponse(HttpServletResponse httpServletResponse, File zipFile) throws IOException {
        boolean bytesWritten = false;
        ServletOutputStream out = httpServletResponse.getOutputStream();
        FileInputStream in = new FileInputStream(zipFile);
        byte[] buffer = new byte[4096];
        try {
            int bytesRead;
            while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
                bytesWritten = true;
            }
        }
        finally {
            IOUtil.shutdownStream(in);
            IOUtil.shutdownStream((OutputStream)out);
        }
        return bytesWritten;
    }

    private void setResponseHeaders(HttpServletResponse response, File zipFile, String issueKey) throws IOException {
        this.setFileDownloadHeaders(response, zipFile, issueKey + ".zip", "application/zip", CONTENT_DISPOSITION_ATTACHMENT);
    }

    private void setFileDownloadHeaders(HttpServletResponse httpServletResponse, File file, String entryFileName, String contentType, String contentDisposition) {
        ApplicationProperties ap = this.getApplicationProperties();
        String jiraFileEncoding = ap.getEncoding();
        String codedFileName = JiraUrlCodec.encode(entryFileName, true);
        httpServletResponse.setContentType(contentType);
        httpServletResponse.setContentLength((int)file.length());
        httpServletResponse.setHeader("Content-Disposition", contentDisposition + "; filename*=" + jiraFileEncoding + "''" + codedFileName + ";");
    }

    private boolean hasPermissionToViewAttachment(Issue issue) throws DataAccessException {
        return ComponentAccessor.getPermissionManager().hasPermission(10, issue, this.getLoggedInUser());
    }

    private void deleteFile(File zipFile) {
        if (zipFile != null) {
            zipFile.delete();
        }
    }

    private boolean checkSupportEnabled() {
        ApplicationProperties ap = this.getApplicationProperties();
        return ap.getOption("jira.option.allowattachments") && ap.getOption("jira.attachment.allow.zip.support");
    }

    ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    protected User getLoggedInUser() {
        return ComponentManager.getComponent(JiraAuthenticationContext.class).getLoggedInUser();
    }
}

