/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.servlet;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.NotFoundException;
import com.atlassian.jira.exception.PermissionException;
import com.atlassian.jira.util.http.JiraHttpUtils;
import com.atlassian.jira.web.exception.WebExceptionChecker;
import com.atlassian.jira.web.servlet.InvalidAttachmentPathException;
import com.atlassian.jira.web.servlet.ViewAttachmentServlet;
import com.atlassian.seraph.auth.AuthenticationContextImpl;
import com.atlassian.seraph.util.RedirectUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public abstract class AbstractViewFileServlet
extends HttpServlet {
    private static final Logger log = Logger.getLogger(ViewAttachmentServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            File attachmentFile;
            try {
                attachmentFile = this.getFileName(request, response);
            }
            catch (InvalidAttachmentPathException e) {
                response.sendError(400, "Invalid attachment path");
                return;
            }
            catch (AttachmentNotFoundException nfe) {
                response.sendError(404, "Attachment not found (id " + nfe.getAttachmentId() + ")");
                return;
            }
            catch (PermissionException e) {
                this.redirectForSecurityBreach(request, response);
                return;
            }
            if (attachmentFile == null) {
                throw new NotFoundException("Attachment not found");
            }
            this.streamFileData(request, response, attachmentFile);
        }
        catch (Exception e) {
            if (WebExceptionChecker.canBeSafelyIgnored(e)) {
                return;
            }
            log.error((Object)("Error serving file for path " + request.getPathInfo() + ": " + e.getMessage()), (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private void redirectForSecurityBreach(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.getUserName() != null) {
            RequestDispatcher rd = request.getRequestDispatcher("/secure/views/securitybreach.jsp");
            JiraHttpUtils.setNoCacheHeaders(response);
            rd.forward((ServletRequest)request, (ServletResponse)response);
        } else {
            response.sendRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)request));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void streamFileData(HttpServletRequest request, HttpServletResponse response, File attachmentFile) throws IOException {
        FileInputStream in = null;
        ServletOutputStream out = null;
        try {
            try {
                in = new FileInputStream(attachmentFile);
            }
            catch (FileNotFoundException e) {
                log.error((Object)("Error finding " + request.getPathInfo() + " : " + e.getMessage()));
                response.sendError(500, "Could not find the specified attachment on the server");
                AbstractViewFileServlet.close(in);
                AbstractViewFileServlet.close((Closeable)out);
                return;
            }
        }
        catch (Throwable throwable) {
            AbstractViewFileServlet.close(in);
            AbstractViewFileServlet.close(out);
            throw throwable;
        }
        out = response.getOutputStream();
        this.setResponseHeaders(request, response);
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
            out.flush();
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error serving content to client", (Throwable)e);
            }
        }
        AbstractViewFileServlet.close(in);
        AbstractViewFileServlet.close((Closeable)out);
    }

    protected final String attachmentPath(HttpServletRequest request) {
        String pi = request.getPathInfo();
        if (pi == null || pi.length() == 1 || pi.indexOf(47, 1) == -1) {
            throw new InvalidAttachmentPathException();
        }
        return pi;
    }

    protected abstract File getFileName(HttpServletRequest var1, HttpServletResponse var2) throws InvalidAttachmentPathException, DataAccessException, IOException, PermissionException;

    protected abstract void setResponseHeaders(HttpServletRequest var1, HttpServletResponse var2) throws InvalidAttachmentPathException, DataAccessException, IOException;

    protected final String getUserName() {
        User user = (User)new AuthenticationContextImpl().getUser();
        return user != null ? user.getName() : null;
    }

    private static void close(Closeable close) {
        block3: {
            if (close != null) {
                try {
                    close.close();
                }
                catch (IOException e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)"Error closing streams after serving content", (Throwable)e);
                }
            }
        }
    }
}

