/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.monitor.watcher;

import com.atlassian.jira.web.monitor.Request;
import com.atlassian.jira.web.monitor.watcher.ActiveRequestsCallback;
import com.atlassian.jira.web.monitor.watcher.OverdueRequestListener;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestWatcher {
    private final Logger log = LoggerFactory.getLogger(RequestWatcher.class);
    private final ScheduledExecutorService executorService;
    private final List<OverdueRequestListener> overdueListeners = new CopyOnWriteArrayList<OverdueRequestListener>();
    private final AtomicReference<ScheduledFuture<?>> scheduledFuture = new AtomicReference();
    private final long overdueThreshold;
    private final ActiveRequestsCallback callback;

    public RequestWatcher(long overdueThreshold, ActiveRequestsCallback callback) {
        this.executorService = this.newSingleThreadExecutor();
        this.overdueThreshold = overdueThreshold;
        this.callback = callback;
    }

    public void addOverdueRequestListener(OverdueRequestListener overdueRequestListener) {
        this.overdueListeners.add(overdueRequestListener);
        this.log.debug("[{}] Added overdue request listener: {}", (Object)this, (Object)overdueRequestListener);
    }

    public void removeOverdueRequestListener(OverdueRequestListener overdueRequestListener) {
        this.overdueListeners.remove(overdueRequestListener);
        this.log.debug("[{}] Removed overdue request listener: {}", (Object)this, (Object)overdueRequestListener);
    }

    public void startWatching() {
        long period = this.overdueThreshold / 2L;
        this.scheduledFuture.set(this.executorService.scheduleAtFixedRate(new FindOverdueRequests(), period, period, TimeUnit.MILLISECONDS));
        this.log.debug("[{}] started watching, threshold is {}ms", (Object)this, (Object)this.overdueThreshold);
    }

    public void stopWatching() {
        ScheduledFuture future = this.scheduledFuture.getAndSet(null);
        if (future != null) {
            future.cancel(false);
        }
        this.log.debug("[{}] stopped watching", (Object)this);
    }

    public void close() {
        this.executorService.shutdown();
        this.log.debug("[{}] closed", (Object)this);
    }

    protected ScheduledExecutorService newSingleThreadExecutor() {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r, "requestwatcher-thread");
                RequestWatcher.this.log.debug("[{}] Created watcher thread: {}", (Object)this, (Object)thread);
                return thread;
            }
        });
    }

    protected void notifyOverdueListeners(List<Request> overdue, long overdueThreshold) {
        this.log.debug("[{}] Overdue requests: {}", (Object)this, overdue);
        for (OverdueRequestListener listener : this.overdueListeners) {
            try {
                this.log.trace("[{}] Calling listener: {}", (Object)this, (Object)listener);
                listener.requestsOverdue(overdue, overdueThreshold);
            }
            catch (RuntimeException e) {
                this.log.error(String.format("[%s] Error in listener", this), (Throwable)e);
            }
        }
    }

    private class FindOverdueRequests
    implements Runnable {
        private FindOverdueRequests() {
        }

        @Override
        public void run() {
            ArrayList requests = Lists.newArrayList(RequestWatcher.this.callback.get());
            ArrayList overdueRequests = Lists.newArrayList();
            for (Request request : requests) {
                long runningMillis;
                if (request == null || (runningMillis = TimeUnit.MILLISECONDS.convert(request.getRunningTime(), TimeUnit.NANOSECONDS)) <= RequestWatcher.this.overdueThreshold) continue;
                overdueRequests.add(request);
            }
            if (!overdueRequests.isEmpty()) {
                RequestWatcher.this.notifyOverdueListeners(overdueRequests, RequestWatcher.this.overdueThreshold);
            }
        }
    }
}

