/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.monitor;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.monitor.LongRequestMXBeanImpl;
import com.atlassian.jira.web.monitor.Request;
import com.atlassian.jira.web.monitor.dump.Dumper;
import com.atlassian.jira.web.monitor.jmx.JMXBean;
import com.atlassian.jira.web.monitor.jmx.JMXException;
import com.atlassian.jira.web.monitor.watcher.ActiveRequestsCallback;
import com.atlassian.jira.web.monitor.watcher.OverdueRequestListener;
import com.atlassian.jira.web.monitor.watcher.RequestWatcher;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveRequestsFilter
implements Filter {
    public static final String JMX_NAME_PARAM = "jmx.name";
    private static final String LOG_THRESHOLD = "request.log.threshold";
    private static final String DUMPTHREADS_THRESHOLD = "request.dumpthreads.threshold";
    private static final String DUMPTHREADS_DIR_PARAM = "request.dumpthreads.dir";
    private final Logger log = LoggerFactory.getLogger(ActiveRequestsFilter.class);
    private final AtomicInteger logThreshold = new AtomicInteger(0);
    private final AtomicInteger dumpThreadsThreshold = new AtomicInteger(0);
    private final AtomicReference<String> dumpThreadsDir = new AtomicReference<Object>(null);
    private final AtomicReference<FilterFunc> filterFunc = new AtomicReference<Object>(null);
    private final AtomicReference<JMXBean> jmxBean = new AtomicReference<Object>(null);

    public void init(FilterConfig filterConfig) {
        int logThreshold = Integer.valueOf(filterConfig.getInitParameter(LOG_THRESHOLD));
        int dumpThreadsThreshold = Integer.valueOf(filterConfig.getInitParameter(DUMPTHREADS_THRESHOLD));
        String dumpThreadsDir = this.getDumpDirFromConfig(filterConfig);
        this.setLogThreshold(logThreshold);
        this.setDumpThreadsThreshold(dumpThreadsThreshold);
        this.setDumpThreadsDir(dumpThreadsDir);
        String jmxName = filterConfig.getInitParameter(JMX_NAME_PARAM);
        if (jmxName != null) {
            this.initJMX(jmxName);
        }
        this.settingsUpdated();
        this.log.debug("Initialised");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.filterFunc.get().doFilter(servletRequest, servletResponse, filterChain);
    }

    public void destroy() {
        this.destroyJMX();
        FilterFunc oldFunc = this.filterFunc.getAndSet(null);
        if (oldFunc != null) {
            oldFunc.close();
        }
        this.log.debug("Destroyed");
    }

    int getDumpThreadsThreshold() {
        return this.dumpThreadsThreshold.get();
    }

    void setDumpThreadsThreshold(int dumpThreadsThreshold) {
        this.dumpThreadsThreshold.set(dumpThreadsThreshold);
        this.settingsUpdated();
        if (dumpThreadsThreshold > 0) {
            this.log.info("Enabled dump threads threshold. Requests that take longer than {}ms will cause a thread dump to be created", (Object)dumpThreadsThreshold);
        } else {
            this.log.info("Disabled dump threads threshold");
        }
    }

    String getDumpThreadsDir() {
        return this.dumpThreadsDir.get();
    }

    void setDumpThreadsDir(String directory) {
        this.dumpThreadsDir.set(directory);
        this.log.info("Set thread dump directory to '{}'", (Object)directory);
    }

    int getLogThreshold() {
        return this.logThreshold.get();
    }

    void setLogThreshold(int logThreshold) {
        this.logThreshold.set(logThreshold);
        this.settingsUpdated();
        if (logThreshold > 0) {
            this.log.info("Enabled log threshold. Requests that take longer than {}ms will be logged", (Object)logThreshold);
        } else {
            this.log.info("Disabled log threshold");
        }
    }

    void settingsUpdated() {
        int dumpMillis;
        FilterFunc newFunc = new PassToChainFilterFunc();
        int logMillis = this.logThreshold.get();
        if (logMillis > 0) {
            newFunc = new DebugLogFilterFunc(logMillis, newFunc);
        }
        if ((dumpMillis = this.dumpThreadsThreshold.get()) > 0) {
            newFunc = new WatchRequestsFilterFunc(dumpMillis, newFunc);
        }
        this.log.debug("Setting filter-func chain: {}", (Object)newFunc);
        FilterFunc oldFunc = this.filterFunc.getAndSet(newFunc);
        if (oldFunc != null) {
            oldFunc.close();
        }
    }

    private void initJMX(String objectName) {
        try {
            this.jmxBean.set(new JMXBean<LongRequestMXBeanImpl>(new LongRequestMXBeanImpl(this), objectName).register());
        }
        catch (JMXException e) {
            this.log.error("Error registering in JMX. You will not be able to change settings at runtime", (Throwable)e);
        }
    }

    private void destroyJMX() {
        JMXBean beanRef = this.jmxBean.getAndSet(null);
        if (beanRef != null) {
            try {
                beanRef.unregister();
            }
            catch (JMXException e) {
                this.log.error("Error unregistering bean in JMX", (Throwable)e);
            }
        }
    }

    private String getDumpDirFromConfig(FilterConfig filterConfig) {
        String threadDumpDir = filterConfig.getInitParameter(DUMPTHREADS_DIR_PARAM);
        if (threadDumpDir == null) {
            threadDumpDir = System.getProperty("user.home");
            this.log.info("init-param {} not specified, defaulting to home directory", (Object)DUMPTHREADS_DIR_PARAM);
        }
        return threadDumpDir;
    }

    @Immutable
    private static class ThreadNameAndRuntime
    implements Function<Request, String> {
        private ThreadNameAndRuntime() {
        }

        public String apply(@Nullable Request from) {
            return String.format("%s (%dms)", from.getThreadName(), TimeUnit.MILLISECONDS.convert(from.getRunningTime(), TimeUnit.NANOSECONDS));
        }
    }

    private class MyOverdueRequestListener
    implements OverdueRequestListener {
        final ThreadNameAndRuntime formatter = new ThreadNameAndRuntime();

        private MyOverdueRequestListener() {
        }

        @Override
        public void requestsOverdue(List<Request> requests, long overdueThreshold) {
            String dir = (String)ActiveRequestsFilter.this.dumpThreadsDir.get();
            String dumpFile = new Dumper().dumpThreads(dir);
            ActiveRequestsFilter.this.log.warn(String.format("Threads have been running for more than %dms, wrote thread dump to '%s': %s", overdueThreshold, dumpFile != null ? dumpFile : "System.err", StringUtils.join((Collection)Lists.transform(requests, (Function)this.formatter), (String)", ")));
        }
    }

    final class DebugLogFilterFunc
    extends FilterFunc {
        private final int threshold;
        private final FilterFunc next;

        public DebugLogFilterFunc(int threshold, FilterFunc next) {
            this.threshold = threshold;
            this.next = Assertions.notNull("delegate", next);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            long start = System.nanoTime();
            try {
                this.next.doFilter(servletRequest, servletResponse, filterChain);
            }
            finally {
                long timeTaken = TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                if (timeTaken > (long)this.threshold) {
                    ActiveRequestsFilter.this.log.debug("Request took longer than {}ms (completed in {}ms)", (Object)this.threshold, (Object)timeTaken);
                }
            }
        }

        @Override
        void close() {
            super.close();
            this.next.close();
        }

        public String toString() {
            return "LogWarnFilterFunc{threshold=" + this.threshold + ", next=" + this.next + '}';
        }
    }

    final class WatchRequestsFilterFunc
    extends FilterFunc {
        private final int threshold;
        private final FilterFunc next;
        private final ConcurrentMap<Request, Request> activeRequests = new ConcurrentHashMap<Request, Request>();
        private final RequestWatcher watcher;

        WatchRequestsFilterFunc(int threshold, FilterFunc next) {
            this.threshold = threshold;
            this.next = next;
            this.watcher = new RequestWatcher(threshold, new ActiveRequestsCallback(){

                @Override
                public Collection<Request> get() {
                    return WatchRequestsFilterFunc.this.activeRequests.values();
                }
            });
            this.watcher.addOverdueRequestListener(new MyOverdueRequestListener());
            this.watcher.startWatching();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            Request request = new Request(System.nanoTime(), Thread.currentThread().getName());
            this.activeRequests.put(request, request);
            ActiveRequestsFilter.this.log.trace("Added to active requests: {}", (Object)request);
            try {
                this.next.doFilter(servletRequest, servletResponse, filterChain);
            }
            finally {
                this.activeRequests.remove(request);
                ActiveRequestsFilter.this.log.trace("Removed from active requests: {}", (Object)request);
            }
        }

        @Override
        void close() {
            this.watcher.stopWatching();
            this.watcher.close();
            super.close();
            this.next.close();
        }

        public String toString() {
            return "WatchRequestsFilterFunc{threshold=" + this.threshold + ", next=" + this.next + '}';
        }
    }

    static final class PassToChainFilterFunc
    extends FilterFunc {
        PassToChainFilterFunc() {
        }

        @Override
        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    static abstract class FilterFunc {
        FilterFunc() {
        }

        abstract void doFilter(ServletRequest var1, ServletResponse var2, FilterChain var3) throws IOException, ServletException;

        void close() {
        }
    }
}

