/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.steps;

import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.filters.steps.FilterCallContext;
import com.atlassian.jira.web.filters.steps.FilterCallContextImpl;
import com.atlassian.jira.web.filters.steps.FilterStep;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ChainedFilterStepRunner
implements Filter {
    private final String filterName = this.getClass().getCanonicalName() + "_alreadyfiltered";

    protected ChainedFilterStepRunner() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    protected abstract List<FilterStep> getFilterSteps();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if (servletRequest.getAttribute(this.filterName) != null) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        httpServletRequest.setAttribute(this.filterName, (Object)Boolean.TRUE);
        List<FilterStep> filterSteps = Assertions.notNull("filterSteps", this.getFilterSteps());
        FilterCallContext callContext = new FilterCallContextImpl(httpServletRequest, httpServletResponse, filterChain);
        try {
            for (FilterStep filterStep : filterSteps) {
                callContext = Assertions.notNull("callContext", filterStep.beforeDoFilter(callContext));
            }
            callContext.getFilterChain().doFilter((ServletRequest)callContext.getHttpServletRequest(), (ServletResponse)callContext.getHttpServletResponse());
        }
        catch (Throwable throwable) {
            for (FilterStep filterStep : Iterables.reverse(filterSteps)) {
                callContext = Assertions.notNull("callContext", filterStep.finallyAfterDoFilter(callContext));
            }
            throw throwable;
        }
        for (FilterStep filterStep : Iterables.reverse(filterSteps)) {
            callContext = Assertions.notNull("callContext", filterStep.finallyAfterDoFilter(callContext));
        }
    }
}

