/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters.gzip;

import com.atlassian.gzipfilter.GzipFilter;
import com.atlassian.gzipfilter.integration.GzipFilterIntegration;
import com.atlassian.jira.ManagerFactory;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class JiraGzipFilter
extends GzipFilter {
    private static final Logger log = Logger.getLogger(JiraGzipFilter.class);

    public JiraGzipFilter() {
        super((GzipFilterIntegration)new JiraGzipFilterIntegration());
    }

    private static class JiraGzipFilterIntegration
    implements GzipFilterIntegration {
        private JiraGzipFilterIntegration() {
        }

        public boolean useGzip() {
            try {
                return ManagerFactory.getApplicationProperties().getOption("jira.option.web.usegzip");
            }
            catch (RuntimeException e) {
                log.debug((Object)"Cannot get application properties, defaulting to no GZip filter");
                return false;
            }
        }

        public String getResponseEncoding(HttpServletRequest httpServletRequest) {
            return ManagerFactory.getApplicationProperties().getEncoding();
        }
    }
}

