/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.filters;

import com.atlassian.jira.util.dbc.Assertions;
import javax.servlet.FilterConfig;
import org.apache.commons.lang.StringUtils;

final class InitParamSupport {
    private final String key;
    private final boolean required;

    static InitParamSupport required(String key) {
        return new InitParamSupport(key, true);
    }

    static InitParamSupport optional(String key) {
        return new InitParamSupport(key, false);
    }

    private InitParamSupport(String key, boolean required) {
        this.key = Assertions.notNull("key", key);
        this.required = required;
    }

    String key() {
        return this.key;
    }

    String get(FilterConfig config) {
        String value = config.getInitParameter(this.key);
        if (StringUtils.isEmpty((String)value) && this.required) {
            throw new IllegalStateException("Required init parameter missing <" + this.key + ">");
        }
        return value;
    }
}

